/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)cproctab.c	1.19 2/17/92 */

#define _BSD 43

#include <rpc/rpc.h>

#include "cfunc.h"

#include "parse.h"
#include "fdhandlers.h"
#ifdef remove
#  undef remove
#endif
#include <stdio.h>
#include "streamop.h"

void C_cload();
void C_readobject();
void C_writeobject();
void C_access();
void C_storeprogram();

void C_stat_mtime();

void C_parsedef();
void C_parseproc();

void C_fdread();
void C_fdwrite();
void C_fdclose();
void C_window();

void C_start_network();
void C_set_linking_port();
void C_get_link();

void C_get_time();
void C_crtoa();

void C_stdstreams();
void C_clearerrno();
void C_ctermid();
void C_cuserid();
void C_tmpnam();
void C_read_errno();
void C_fopen();
void C_fdopen();
void C_popen();
void C_tmpfile();
void C_clearerr();
void C_ferror();
void C_ferrno();
void C_feof();
void C_fileno();
void C_fflush();
void C_fseek();
void C_rewind();
void C_ftell();
void C_setlinebuf();
void C_fstat();
void C_fclose();
void C_pclose();
void C_freopen();
void C_readstream();
void C_readword();
void C_writestream();
void C_writeword();

/* C Process Table.  A nil function pointer indicates the end of the table. */

cproc_entry cproctab[] = {
    { C_cload, 0, "C Load", "C Process loader" },
				/* C processes are always looked up starting */
				/* in position 1, so this is mainly a place */
				/* holder. */
    { C_readobject, 0, "Read Object", "Read Polymorphed Object" },
    { C_writeobject, 0, "Write Object", "Write Polymorphed Object" },
    { C_stat_mtime, 0, "File Modification Time", "File Modification Time" },
    { C_parsedef, sizeof(feprocessdata), "Parse Def", "Parse Definition File"},
    { C_parseproc, sizeof(feprocessdata), "Parse Proc",
	"Parse Process File" },
    { C_fdread, sizeof(FDREADDATA), "FD Read", "File Descriptor Reader"},
    { C_fdwrite, sizeof(FDWRITEDATA), "FD Write", "File Descriptor Writer"},
    { C_fdclose, sizeof(FDCLOSEDATA), "FD Close", "File Descriptor Closer"},
    { C_window, 0, "Window", "Open a Display Window"},
    { C_start_network, 0, "start network", "Initialize inter-hermi RPC" },
    { C_set_linking_port, 0, "set linking port", "Initialize inport for RPC" },
    { C_get_link, 0, "get link", "Get outport for RPC" },
    { C_get_time, 0, "date and time", "Get current date and time" },
    { C_crtoa, 0, "crtoa", "Convert real to ascii string" },
    { C_stdstreams, 0, "stdstreams",
	"Return stdin, stdout, and stderr stream handles" },
    { C_clearerrno, 0, "clearerrno", "Clear the errno variable" },
    { C_ctermid, 0, "ctermid", "Get name of controlling terminal" },
    { C_cuserid, 0, "cuserid", "Get login name of user" },
    { C_tmpnam, 0, "tmpnam", "Generating a temporary filename" },
    { C_access, 0, "Access", "Check on accessibility of a file" },
    { C_read_errno, 0, "read errno",
	"return current value of errno variable" },
    { C_fopen, 0, "fopen", "Open a file" },
    { C_fdopen, 0, "fdopen", "Create a stream from an open file descriptor" },
    { C_popen, 0, "popen", "Run a command in a child process" },
    { C_tmpfile, 0, "tmpfile", "Open a temporary file with a generated name" },
    { C_clearerr, sizeof(STREAMOPDATA), "clearerr",
	"Clear error condition on a stream" },
    { C_ferror, sizeof(STREAMOPDATA), "ferror",
	"Check error condition on a stream" },
    { C_ferrno, sizeof(STREAMOPDATA), "ferrno",
	"Return most recent error code encountered on a stream" },
    { C_feof, sizeof(STREAMOPDATA), "feof",
	"Check for EOF condition on a stream" },
    { C_fileno, sizeof(STREAMOPDATA), "fileno",
	"Get underlying file descriptor for a stream" },
    { C_fflush, sizeof(STREAMOPDATA), "fflush",
	"Flush output pending on a stream" },
    { C_fseek, sizeof(STREAMOPDATA), "fseek",
	"Set position for I/O on a stream" },
    { C_rewind, sizeof(STREAMOPDATA), "rewind",
	"Reset a stream to its beginning" },
    { C_ftell, sizeof(STREAMOPDATA), "ftell",
	"Get current position for I/O on a stream" },
    { C_setlinebuf, sizeof(STREAMOPDATA), "setlinebuf",
	"Set line buffered mode for a stream" },
    { C_fstat, sizeof(STREAMOPDATA), "fstat", "Get file info for a stream" },
    { C_fclose, sizeof(STREAMOPDATA), "fclose", "Close a stream" },
    { C_pclose, sizeof(STREAMOPDATA), "pclose",
	"Close a stream opened with popen" },
    { C_freopen, sizeof(STREAMOPDATA), "freopen",
	"Open a new file for an existing stream" },
    { C_readstream, sizeof(STREAMOPDATA), "readstream",
	"Read data from a stream" },
    { C_readword, sizeof(STREAMOPDATA), "readword",
	"Read the next word from a stream" },
    { C_writestream, sizeof(STREAMOPDATA), "writestream",
	"Write characters on a stream" },
    { C_writeword, sizeof(STREAMOPDATA), "writeword",
	"Write a word value on a stream" },
    { nil, 0, nil, nil }
};


dfd_enumeration
lookup_cprocess(name)
char *name;
{
    dfd_enumeration pos;

    for (pos = 1; cproctab[pos].name isnt nil; pos++) 
      if (strcmp(cproctab[pos].name, name) is 0)
	return(pos);

    return(0);			/* zero indicates failure. */
}

char *
cprocname(addr)
void (*addr)();
{
  int pos;
  for (pos = 0; cproctab[pos].name isnt nil; pos++)
    if (addr is cproctab[pos].funcp)
      return(cproctab[pos].name);
  return("unkonwn");
}
