/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* SCCS Info: @(#)Makefile.cpp	1.3 2/17/92 */

#include "includefile"


LINTLIBS =	-lhaux -lcherm

SRCS	=	signalio.c cproctab.c $(CH)

CH	=	readobject.ch parsemod.ch \
		writeobject.ch stat_mtime.ch \
		window.ch fdhandlers.ch rpcserver.ch rpcclient.ch \
		time.ch crtoa.ch stdio.ch

COBJS	=	readobject.c parsemod.c \
		writeobject.c stat_mtime.c \
		window.c fdhandlers.c rpcserver.c rpcclient.c \
		time.c crtoa.c stdio.c

OBJS	=	readobject.o parsemod.o \
		writeobject.o stat_mtime.o  \
		window.o fdhandlers.o signalio.o \
		rpcclient.o cproctab.o rpcserver.o time.o crtoa.o \
		stdio.o


all: libcfunc.a

libcfunc.a: $(OBJS)
	ar r libcfunc.a $?
	$(RANLIB) libcfunc.a

llib-lcfunc.ln: libcfunc.a
	$(LINT) $(LFLAGS) $(COBJS)
	$(LINT) -Ccfunc $(LFLAGS) $(COBJS) >/dev/null

parsemod.c: parsemod.ch feproc.h

readobject.c: readobject.ch

writeobject.c: writeobject.ch

stat_mtime.c: stat_mtime.ch

rpcserver.c: rpcserver.ch rpc.h

rpcclient.c: rpcclient.ch rpc.h 

stdio.c: streamop.h

fdhandlers.c: fdhandlers.ch 
fdhandlers.o: fdhandlers.c fdhandlers.h $(CDDIR)/fdhandlers.cd

window.c: window.ch
window.o: window.c $(CDDIR)/cwindow.cd

time.c: time.ch
time.o: time.c $(CDDIR)/time.cd

crtoa.c: crtoa.ch
crtoa.o: crtoa.c $(CDDIR)/crtoa.cd

cproctab.o: cproctab.c streamop.h parse.h fdhandlers.h

/* cleanup */
clean::
	rm -f *.cd $(COBJS)
