/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: defacts.ch */
/* Author: David Bacon & Andy Lowry */
/* SCCS Info: @(#)defacts.ch	1.7 2/18/92 */

#include <string.h>
#include <sys/file.h>

#include "cherm.h"

#include "predefined.cd"
#include "filedef.cd"


hobject(Modules, table);	/* predefined!definitions_printmappings */
hobject(PD_Printrec, record);	/* definitions printmap for predefined */

void
defmod_init()
{
    char *getenv();
    char *pdname;
    hobject(Name, charstring);
    lobject(Filedef);
    lobject(PolyProg);
    char *hermpath();

    avl2_new_table(Modules, firstandsecond_keyset);
    if ((pdname = getenv("PREDEFINEDMODULE")) is nil)
      pdname = hermpath(nil, "predefined", ".do");
    chs_lit(Name, pdname);
    set_bottom(PolyProg);
    read(PolyProg, Name);
    set_bottom(Filedef);
    unwrap(Filedef, PolyProg, nil);
    set_bottom(PD_Printrec);
    move(PD_Printrec, Filedef@filed_definition__defmap);
}


void
defmod_import(modname)
char *modname;
{
    char *hermpath();

    lobject(Filedef);		/* the filed definition module */
    hobject(Name, charstring);
    char *filename;
    lobject(PolyProg);		/* predefined!polymorph */

    filename = hermpath(nil, modname, ".do");
    chs_lit(Name, filename);
    set_bottom(PolyProg);
    read(PolyProg, Name);	/* read in from the file */
    set_bottom(Filedef);
    unwrap(Filedef, PolyProg, nil);

    insert(Modules, Filedef@filed_definition__defmap);
				/* save the definitions printmap */

/*    discard(Filedef); */
/* fix later: chs_lit with empty string "" seems to produce nil pointer.  see */
/* fe/p_definitions.ch:add_type_def */

}


char *
hermpath(path, file, suffix)
char *path;
char *file;
char *suffix;
{
    char *pathfind();
    char *getenv();
    char *hbindir();
    char *malloc();

    char *fullfile, *bin;


    fullfile = malloc(strlen(file) + strlen(suffix) + 1);
    strcpy(fullfile, file);
    strcat(fullfile, suffix);

    if (path is nil)
      if ((path = getenv("HPATH")) is nil) {
        bin = hbindir();
        path = malloc(strlen(".:") + strlen(bin) + 1);
        strcat(strcpy(path, ".:"), bin);
      }
    return(pathfind(path, fullfile, R_OK));
}

objectp
predefined_typename(type)
char *type;
{
  hobject(Typestr, charstring);
  hobject(Typerec, record);
  objectp Typename;
  char err[256];

  Typename = new_object();
  new_record(Typename, typename);
  chs_lit(Typestr, type);

  if (h_lookup_secondary(Typerec, PD_Printrec@definitions_printmap__types,
			 Typestr, 0) is NotFound) {
    strcpy(err, type);
    yyerror(strcat(err, " is not a known predefined type"));
    return(Typename);
  }
  copy(Typename@typename__moduleid, PD_Printrec@Id);
  copy(Typename@typename__typeid, Typerec@Id);
  return(Typename);
}

objectp
defmod_resolve_typename(module, type)
char *module;
char *type;
{
    hobject(Modulestr, charstring);
    hobject(Typestr, charstring);
    hobject(Printrec, record);
    hobject(Typerec, record);
    objectp Typename;
    char err[256];


    Typename = new_object();
    new_record(Typename, typename);
    chs_lit(Modulestr, module);
    chs_lit(Typestr, type);

    if (h_lookup_secondary(Printrec, Modules, Modulestr, 0) is NotFound) {
	strcpy(err, module);
	yyerror(strcat(err, " is not a known module"));
	return(Typename);
    }

    copy(Typename@typename__moduleid, Printrec@Id);

    if (h_lookup_secondary(Typerec, Printrec@definitions_printmap__types,
			       Typestr, 0) is NotFound) {
	strcpy(err, type);
	yyerror(strcat(err, " is not a known type"));
	return(Typename);
    }

    copy(Typename@typename__typeid, Typerec@Id);
       
    return(Typename);
}


objectp
defmod_resolve_userex(Typename, name)
objectp Typename;		/* predefined!typename: callmsg type */
char *name;			/* string: name of exception */
{
    hobject(Prec, record);	/* definitions_printmap */
    hobject(Erec, record);	/* exception_printrec */
    hobject(Ename, chs_table);	/* charstring */
    objectp Userex;		/* user_exception */
    char err[128];

    if (h_lookup(Prec, Modules, Typename@typename__moduleid, 0) 
	is NotFound) {
	yyerror("Panic: can't find resolved module id");
	return(nil);
    }

    Userex = new_object();
    new_record(Userex, user_exception);
    chs_lit(Ename, name);

    if (h_lookup_secondary(Erec, Prec@definitions_printmap__exceptions,
			       Typename@typename__typeid, Ename, 0)
	is NotFound) {
	yyerror(strcat(strcpy(err, name), " isn't a defined exception"));
	unique(Userex@user_exception__exceptionid);
				/* make up a bogus id */
    }
    else
      copy(Userex@user_exception__exceptionid, 
	   Erec@exception_printrec__exception);

    move(Userex@user_exception__type, Typename);
    return(Userex);
}
