-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)actions.d	1.4 2/17/92

actions: using (predefined)
definitions

labels: table of label_rec { full } keys (label);

label_rec: record (
	label: charstring,
	statement: integer 
);



backpatch: table of backpatch_rec { full } keys (label);

backpatch_rec: record (
	label: charstring,
	reflist: labelref_list
);

labelref_list: ordered table of labelref_rec { full };

labelref_rec: record (
	statement: integer,
	ref: labelref
);

labelref_type: enumeration ( 'branch', 'select', 'handler', 'labelpair' );

labelref: variant of labelref_type (
	'branch' -> branch: empty {},
	'labelpair' -> pairpos: integer { init },
	'select' -> selectpos: integer { init },
	'handler' -> handlerpos: handlername { init }
);

exit_table: table of exit_rec { full } keys (name);

exit_rec: record (
	name: charstring,
	exitid: exitid
);

printmap: table of printmap_rec {full} keys (name);
printmap_rec: record (
  name: charstring,
  id: processid
);

end definitions
