/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* File: Makefile */
/* Author: Andy Lowry */
/* SCCS Info: @(#)Makefile	1.55 2/7/92 */

#include "includefile"

MBINS =	chgram hermes hparse asm construct

/* make variables to be propogated to inferior make's... there are a */
/* few diferent sets that are used in various situations */
NOROOTVARS = 	CLEAN=$(CLEAN) PCOMSTRIPENV=$(PCOMSTRIPENV) ALTNAME=$(ALTNAME) 
MAKEVARS =	HROOT=$(HROOT) $(NOROOTVARS)

/* To make an alternate interpreter... set ALTNAME to a name */
/* identifying this intepreter, and ALTFLAGS to cc */ 
/* flags that will cause the interpreter you want to be built.  E.g.: */
/* for an optimized interpreter:  make newversion interpboot */
/* ALTNAME=opt ALTFLAGS="OPTFLAG=-O DBXFLAG=' '". */ 

newversion:
	-@if [ ! -d $(HROOT) ] ; then \
		echo mkdir $(HROOT) ; mkdir $(HROOT) ; fi
	-@if [ ! -d $(BINDIR) ] ; then \
		echo mkdir $(BINDIR) ; mkdir $(BINDIR) ; fi
	-@if [ ! -d $(HROOT)/mbin ] ; then \
		echo mkdir $(HROOT)/mbin ; mkdir $(HROOT)/mbin ; fi
	-@if [ ! -d $(HROOT)/mbin/_MTYPE_ ] ; then \
		echo mkdir $(HROOT)/mbin/_MTYPE_ ; \
		mkdir $(HROOT)/mbin/_MTYPE_ ; fi
	-@if [ ! -d $(MBINDIR) ] ; then \
		echo mkdir $(MBINDIR) ; mkdir $(MBINDIR) ; fi
#ifdef _DYNAMIC_LINKING_
	-@if [ ! -d $(CHBINDIR) ] ; then \
		echo mkdir $(CHBINDIR) ; mkdir $(CHBINDIR) ; fi
	-@if [ ! -d $(HROOT)/mchbin ] ; then \
		echo mkdir $(HROOT)/mchbin ; mkdir $(HROOT)/mchbin ; fi
	-@if [ ! -d $(HROOT)/mchbin/_MTYPE_ ] ; then \
		echo mkdir $(HROOT)/mchbin/_MTYPE_ ; \
		mkdir $(HROOT)/mchbin/_MTYPE_ ; fi
	-@if [ ! -d $(MCHBINDIR) ] ; then \
		echo mkdir $(MCHBINDIR) ; mkdir $(MCHBINDIR) ; fi
	-@if [ ! -d $(CHBINDIR)/src ] ; then \
		echo mkdir $(CHBINDIR)/src ; mkdir $(CHBINDIR)/src ; fi
	-@if [ ! -d $(CHBINDIR)/skel ] ; then \
		echo mkdir $(CHBINDIR)/skel ; mkdir $(CHBINDIR)/skel ; fi
#endif

/* HROOT should give the current working system root; everything must */
/* be checked in!  */

PRECOMP	= $(HROOT)/.precomp
precompilerboot:
	( cd $(HROOT) ; rm -rf .precomp ; mkdir .precomp )
	( cd $(PRECOMP) ; ln -s $(HROOT)/?* . ; rm interface ; \
		mkdir interface )
	( cd $(PRECOMP)/interface ; ln -s $(HROOT)/interface/SCCS . ; \
		sccs get -s SCCS ; rm -f Makefile )
	( cd $(PRECOMP) ; rm hermes ; mkdir hermes )
	( cd $(PRECOMP)/hermes ; ln -s $(HROOT)/hermes/?* . ; rm defs ; \
		mkdir defs )
	( cd $(PRECOMP)/hermes/defs ; ln -s $(HROOT)/hermes/defs/SCCS . ; \
		sccs get -s SCCS ; rm -f Makefile)
	( cd $(PRECOMP) ; rm codegen ; mkdir codegen )
	( cd $(PRECOMP)/codegen ; ln -s $(HROOT)/codegen/?* . ; rm com ; \
		mkdir com )
	( cd $(PRECOMP)/codegen/com ; ln -s $(HROOT)/codegen/com/SCCS . ; \
		sccs get -s SCCS  ; rm -f Makefile )
	( cd $(PRECOMP) ; mkdir .gen )
	( cd $(PRECOMP) ; rm -f hermes/ligen/Makefile codegen/ligen/Makefile )
	( cd $(PRECOMP) ; yes y | env HROOTDIR=$(PRECOMP) ./make-makefiles \
		interface hermes/defs codegen/com hermes/ligen \
		codegen/ligen )
	$(MAKE) newversion HROOT=$(PRECOMP)/.gen $(NOROOTVARS)
	$(MAKE) cleanbin cleanmbin HROOT=$(PRECOMP)/.gen $(NOROOTVARS)
	( cd $(PRECOMP)/interface; \
		$(MAKE) clean boot install \
		HROOT=$(PRECOMP) $(NOROOTVARS) GENHROOT=$(PRECOMP)/.gen )
	( cd $(PRECOMP)/hermes/defs ; \
		$(MAKE) clean boot \
		HROOT=$(PRECOMP) $(NOROOTVARS) GENHROOT=$(PRECOMP)/.gen )
	( cd $(PRECOMP)/codegen/com ; \
		$(MAKE) clean boot-dofiles \
		HROOT=$(PRECOMP) $(NOROOTVARS) GENHROOT=$(PRECOMP)/.gen )
	( cd $(PRECOMP)/hermes/ligen ; \
		$(MAKE) clean install \
		HROOT=$(PRECOMP) $(NOROOTVARS) GENHROOT=$(PRECOMP)/.gen )
	( cd $(PRECOMP)/codegen/ligen ; \
		$(MAKE) clean install \
		HROOT=$(PRECOMP) $(NOROOTVARS) GENHROOT=$(PRECOMP)/.gen )

/* HROOT should give working system root */
/* Following target generates the li sources that are included in  */
/* the source distribution */
generate-lifiles:
	( cd $(HROOT)/hermes/ligen ; \
		$(MAKE) clean install $(MAKEVARS) )
	( cd $(HROOT)/codegen/ligen ; \
		$(MAKE) clean install $(MAKEVARS) )

/* Following target makes sure all the non-source SCCS files in the */
/* Hermes tree are up-to-date.  There should be no out-of-date files */
/* in the tree prior to this step (in paricular, do a */
/* "generate-lifiles" or "precompilerboot" prior to this step) */

prepare:
	- cp $(HROOT)/update_sccs $(BINDIR)
	- chmod +x $(BINDIR)/update_sccs
	( cd $(HROOT)/hermes/liboot ; $(BINDIR)/update_sccs *.li )
	( cd $(HROOT)/codegen/li ; $(BINDIR)/update_sccs *.li )
	( cd $(HROOT)/chaux ; $(MAKE) package $(MAKEVARS) )
	( cd $(HROOT)/fe ; $(MAKE) package $(MAKEVARS) )
	- cp $(HROOT)/update_sccs $(BINDIR)
	- chmod +x $(BINDIR)/update_sccs
	( cd $(HROOT)/doc ; $(BINDIR)/update_sccs user.ps quick-ref.ps )
	( cd $(HROOT)/doc/chcode ; $(BINDIR)/update_sccs document.ps )
	-rm -f $(BINDIR)/update_sccs

/* HROOT should give the root of the system being booted */
boot:	interpboot compilerboot toolsboot disasmboot \
	chcodeboot demoboot tutboot

/* HROOT should be the root of the system being booted */
interpboot:
	( cd $(HROOT)/lib ; \
		$(MAKE) clean all $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/fe ;  \
		$(MAKE) clean install-chgram $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/interface ; \
		$(MAKE) clean-cdfiles install-cdfiles $(MAKEVARS) \
		$(ALTFLAGS) )
	( cd $(HROOT)/cherm ; \
		$(MAKE) clean all $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/cfunc ; \
		$(MAKE) clean all $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/li ; \
		$(MAKE) clean pre-fe $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/fe ; \
		$(MAKE) install $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/li ; \
		$(MAKE) install $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/asm ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/construct ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) $(ALTFLAGS) )
	@if [ "$(CLEAN)" ] ; then \
		$(MAKE) interpclean $(MAKEVARS) ; fi

updateinterp:
	( cd $(HROOT)/lib ; \
		$(MAKE) all $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/fe ;  \
		$(MAKE) install-chgram $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/interface ; \
		$(MAKE) install-cdfiles $(MAKEVARS) \
		$(ALTFLAGS) )
	( cd $(HROOT)/cherm ; \
		$(MAKE) all $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/cfunc ; \
		$(MAKE) all $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/li ; \
		$(MAKE) pre-fe $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/fe ; \
		$(MAKE) install $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/li ; \
		$(MAKE) install $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/asm ; \
		$(MAKE) install $(CLEAN) $(MAKEVARS) $(ALTFLAGS) )
	( cd $(HROOT)/construct ; \
		$(MAKE) install $(CLEAN) $(MAKEVARS) $(ALTFLAGS) )

/* Following target cleans up the development directories after an */
/* interpreter build, to save disk space */
interpclean:
	( cd $(HROOT)/lib ; $(MAKE) $(CLEAN) )
	( cd $(HROOT)/cherm ; $(MAKE) $(CLEAN) )
	( cd $(HROOT)/cfunc ; $(MAKE) $(CLEAN) )
	( cd $(HROOT)/li ; $(MAKE) $(CLEAN) )
	( cd $(HROOT)/fe ; $(MAKE) $(CLEAN) )
	( cd $(HROOT)/asm ; $(MAKE) $(CLEAN) )
	( cd $(HROOT)/construct ; $(MAKE) $(CLEAN) )

sunwindow:
	( cd $(HROOT)/windows/sunview ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )

xwindow:
	( cd $(HROOT)/windows/xwindow ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )

/* manipulate sets of binaries */
savestdinterp:
	@if [ ! -d $(HROOT)/mbin/_MTYPE_/std ] ; \
		then mkdir $(HROOT)/mbin/_MTYPE_/std ; fi
	( cd $(HROOT)/mbin/_MTYPE_ ; cp $(MBINS) std )

savealtinterp:
	@if [ ! -d $(MBINDIR) ] ; \
		then mkdir $(MBINDIR) ; fi
	( cd $(HROOT)/mbin/_MTYPE_ ; cp $(MBINS) $(MBINDIR) )

usestdinterp:
	( cd $(HROOT)/mbin/_MTYPE_/std ; cp $(MBINS) .. )

usealtinterp: 
	( cd $(MBINDIR) ; cp $(MBINS) .. )

/* HROOT should be root ofthe system being booted */
compilerboot:	cleanbin cleanchbin \
		basiccompiler tccompiler tscompiler checkedcompiler


/* bare bones compiler, and the cache to make life bearable.  pcom and */
/* dcom are both available, but there's no type checking, no type */
/* inferencing (so programs must be typemarked), and no typestate */
/* checking.  Definitions modules are not fixdef'ed. */
basiccompiler:
	( cd $(HROOT)/interface ; \
		$(MAKE) clean-dofiles boot install-dofiles $(MAKEVARS) )
	( cd $(HROOT)/hermes/defs ; \
		$(MAKE) clean boot $(MAKEVARS) )
	( cd $(HROOT)/hermes/liboot ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/codegen/com ; \
		$(MAKE) clean boot-dofiles $(MAKEVARS) )
	( cd $(HROOT)/codegen/p1 ; \
		$(MAKE) clean install $(MAKEVARS) )
	( cd $(HROOT)/hermes/io ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/hermes ; \
		$(MAKE) clean tcboot basicinstall $(MAKEVARS) )
	( cd $(HROOT)/tools/rmanager ; \
		$(MAKE) clean boot install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/tools/cache ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/hermes ; \
		$(MAKE) cacheboot basicinstall $(MAKEVARS) )
	( cd $(HROOT)/codegen/com ; \
		$(MAKE) all $(MAKEVARS) )
	( cd $(HROOT)/codegen/p2 ; \
		$(MAKE) clean all $(MAKEVARS) )
	( cd $(HROOT)/codegen/p1 ; \
		$(MAKE) uninstall $(MAKEVARS) )
	( cd $(HROOT)/codegen/p3 ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	@if [ "$(CLEAN)" ] ; then \
		$(MAKE) codegenclean $(MAKEVARS) ; fi



/* Following target cleans up the codegen build directories after a */
/* normal build, to save disk space */
codegenclean:
	( cd $(HROOT)/codegen/p1 ; $(MAKE) $(CLEAN) )
	( cd $(HROOT)/codegen/p2 ; $(MAKE) $(CLEAN) )
	( cd $(HROOT)/codegen/p3 ; $(MAKE) $(CLEAN) )

/* type-checking compiler.  pcom does type checking and type */
/* inferencing.  dcom still does not do fixdef. */
tccompiler:
	( cd $(HROOT)/interface/gentab ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/type/defs ; \
		$(MAKE) clean all $(MAKEVARS) )
	( cd $(HROOT)/type/common ; \
		$(MAKE) clean all $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/type/bootstrap ; \
		$(MAKE) clean all $(MAKEVARS) )
	( cd $(HROOT)/hermes ; \
		$(MAKE) tsboot basicinstall $(MAKEVARS) )
	( cd $(HROOT)/type/checker ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	@if [ "$(CLEAN)" ] ; then \
		( cd $(HROOT)/type/bootstrap ; $(MAKE) $(CLEAN) ) ; fi


/* the full compiler, but the compiler itself has not been checked... */
/* violations may have gone undetected, and even barring that, no */
/* coercions have been generated in any of the compiler modules, so */
/* a great deal of storage will be wasted.  make 'compiler2' to correct */
/* this situation. */
tscompiler:
	( cd $(HROOT)/hermes/absformat ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/hermes ; \
		$(MAKE) install $(MAKEVARS) )
	( cd $(HROOT)/typestate ; \
		$(MAKE) clean install $(MAKEVARS) )
	( cd $(HROOT)/hermes ; \
		$(MAKE) final install $(CLEAN) $(MAKEVARS) )

/* Following target makes a fully checked and coerced compiler, given a */
/* fully functional but unchecked compiler. */
checkedcompiler:
	( cd $(HROOT)/interface ; \
		$(MAKE) fixdefs install-dofiles $(MAKEVARS) )
	( cd $(HROOT)/hermes/defs ; \
		$(MAKE) fixdefs $(MAKEVARS) )
	( cd $(HROOT)/hermes/absformat ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/hermes ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/hermes/io ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/codegen/com ; \
		$(MAKE) fixdefs $(MAKEVARS) )
	( cd $(HROOT)/codegen/p3 ; \
		$(MAKE) clean install $(CLEAN) \
			$(MAKEVARS) LOADPATH=$(BINDIR) )
	( cd $(HROOT)/type/defs ; \
		$(MAKE) fixdefs $(MAKEVARS) )
	( cd $(HROOT)/type/common ; \
		$(MAKE) clean all $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/type/checker ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/typestate ; \
		$(MAKE) procclean fixdefs install $(CLEAN) $(MAKEVARS) )
	@if [ "$(CLEAN)" ] ; then \
		$(MAKE) compilerclean $(MAKEVARS) ; fi

newbins:
	( cd $(HROOT)/hermes/absformat ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/hermes ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/hermes/io ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/codegen/p3 ; \
		$(MAKE) clean install $(CLEAN) \
			$(MAKEVARS) LOADPATH=$(BINDIR) )
	( cd $(HROOT)/type/common ; \
		$(MAKE) clean all $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/type/checker ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/typestate ; \
		$(MAKE) procclean install $(CLEAN) $(MAKEVARS) )
	@if [ "$(CLEAN)" ] ; then \
		$(MAKE) compilerclean $(MAKEVARS) ; fi

/* Following target cleans up the compiler build directories after a */
/* normal build, to save disk space */
compilerclean:
	( cd $(HROOT)/interface ; $(MAKE) $(CLEAN) )
	( cd $(HROOT)/hermes/defs ; $(MAKE) $(CLEAN) )
	( cd $(HROOT)/codegen/com ; $(MAKE) $(CLEAN) ) 
	( cd $(HROOT)/type/defs ; $(MAKE) $(CLEAN) )
	rm -rf $(HROOT)/interface/cd

/* HROOT should be the root of the system being booted */

disasmboot:
	( cd $(HROOT)/disassembler ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )

/* HROOT should be the root of the system being booted */

chcodeboot:
	( cd $(HROOT)/chcode ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/chaux ; \
		$(MAKE) clean all $(CLEAN) $(MAKEVARS) )
	
/* HROOT should be the root of the system being booted */

toolsboot:
	( cd $(HROOT)/tools/rmanager ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/tools/cache ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/tools/string ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/tools/tokenize ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/tools/make/defs ; \
		$(MAKE) clean install $(MAKEVARS) )
	( cd $(HROOT)/tools/make ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	@if [ "$(CLEAN)" ] ; then \
		( cd $(HROOT)/tools/make/defs ; $(MAKE) $(CLEAN) ) ; fi
	( cd $(HROOT)/tools/shell ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/tools/unixcmd ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/tools/pipe ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/tools/pshell ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	(cd $(HROOT)/tools/distrib ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/tools/profile ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/tools/printobj ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )
	( cd $(HROOT)/windows ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )

/* HROOT should be the root of hte system being booted */
demoboot:
	( cd $(HROOT)/demo ; \
		$(MAKE) clean install $(CLEAN) $(MAKEVARS) )

/* HROOT should be the root of the system being booted */
tutboot:
	( cd $(HROOT)/tutorial_examples ; \
	  rm -f *.?o ; \
	  $(MAKEHERMESCMD) tutorial.target )

/* Remove everything from the binaries directories for the current */
/* hermes system (machine-dependent binaries only) */
cleanmbin:
	( cd $(MBINDIR) ; rm -f *  )
	( cd $(MCHBINDIR) ; rm -f * )

/* Remove machine-independent binaries from the current system */
cleanbin:
	( cd $(BINDIR) ; rm -f $(GARBAGE) )

/* Remove machine-independent c-coded binaries from current system */
cleanchbin:
	( cd $(CHBINDIR) ; rm -f $(GARBAGE) )

/* Remove transformed binaries/ccode from the current system */
cleanchbin:
	( cd $(CHBINDIR) ; rm -rf src skel $(GARBAGE) 2>/dev/null )

/* Go through and chcode all the binaries in the system */
chcode:	dummy
	( cd $(HROOT)/chcode ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/hermes ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/hermes/io ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/hermes/absformat ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/codegen/p3 ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/type/checker ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/typestate ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/windows ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/disassembler ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/cache ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/string ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/make ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/tokenize ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/shell ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/unixcmd ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/rmanager ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/pipe ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/pshell ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/profile ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/printobj ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/distrib ; $(MAKE) chcode $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )

/* Like chcode, but we assume the initial transformation has already */
/* been done, and we're just recompiling for a different platform */
NOCHBIN = LOADPATH=.:$(PROCDIR)
chcompile:	dummy
	( cd $(HROOT)/chcode ; $(MAKE) chcompile $(MAKEVARS) $(NOCHBIN) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/hermes ; $(MAKE) chcompile $(MAKEVARS) $(NOCHBIN) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/hermes/io ; $(MAKE) chcompile $(MAKEVARS) $(NOCHBIN) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/cache ; $(MAKE) chcompile $(MAKEVARS) $(NOCHBIN) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/rmanager ; $(MAKE) chcompile $(MAKEVARS) \
		$(NOCHBIN) CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/string ; $(MAKE) chcompile $(MAKEVARS) $(NOCHBIN) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/hermes/absformat ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/codegen/p3 ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/type/checker ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/typestate ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/windows ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/disassembler ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/make ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/tokenize ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/shell ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/unixcmd ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/pipe ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/pshell ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/profile ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/printobj ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )
	( cd $(HROOT)/tools/distrib ; $(MAKE) chcompile $(MAKEVARS) \
		CHCODEOPTS=$(CHCODEOPTS) )

dummy:
/* Clean up all the build directories, without destroying any of the */
/* binaries */
cleanbuild:
	rm -rf $(CDDIR)
	( cd $(HROOT)/lib ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/cherm ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/cfunc ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/fe ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/li ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/asm ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/construct ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/interface ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/interface/gentab ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/hermes ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/hermes/defs ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/hermes/liboot ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/hermes/ligen ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/hermes/io ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/hermes/absformat ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/codegen/com ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/codegen/p1 ; $(MAKE) clean cleansrc $(MAKEVARS) )
	( cd $(HROOT)/codegen/p2 ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/codegen/p3 ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/codegen/ligen ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/type/defs ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/type/common ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/type/bootstrap ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/type/checker ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/typestate ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/windows ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/windows/sunview ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/disassembler ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/chcode ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/chaux ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/cache ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/string ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/make ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/make/defs ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/tokenize ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/shell ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/unixcmd ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/rmanager ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/pipe ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/pshell ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/profile ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/printobj ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/tools/distrib ; $(MAKE) clean $(MAKEVARS) )
	( cd $(HROOT)/demo ; $(MAKE) clean $(MAKEVARS) )
