-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: tsatc.p
-- Author: Rob Strom
-- SCCS Info: @(#)tsatc.p	1.4 3/13/90

TSATC : USING(Predefined, tscheck, Positions, Errors  ) PROCESS ( AttemptToCoerceInit : AttemptToCoerceInport )
 -- Procedure to determine the coercion needed to drop an attribute  
 -- Given an attribute (Predicate)                                   
 -- Produce:                                                         
 -- 1. What operation drops the attribute (CoercionOp+Coercand)      
 -- 2. What attributes (including the original) are dropped          
 --    as a result of executing this coercion                        
 -- 3. What attributes must be dropped as a prerequisite to          
 --    invoking the coercion                                         
 --                                                                  
 -- Algorithm:                                                       
 -- Case 1:                                                          
 -- Let OBJ be the first object in the attribute.                    
 -- If OBJ has a containing [callmessage                              
 -- or] variant, and dropping this attribute will lower the TS        
 -- below the minimum to keep the CM init or to keep the variant     
 -- in a case ==>                                                    
 --   [Discard the callmessage or] hide the variant                    
 --     (Note:                                                       
 --     It may seem odd that we don't look at the whole attribute,   
 --     but that we pick the first object.                           
 --     Suppose ATTR(P1, P2) is the attribute.  Then we will never be
 --     in Case 1 unless P1 and P2 both have the CM or V as a prefix.
 --     The reason is that the minimum typestate for variant or CM   
 --     can never include another object, so if there is another     
 --     object, e.g. GT(V.X, A), then V.X is above minimum.)         
 --     (The reason for choosing the first rather than               
 --     any random object is because CASE(V, V.X) is really          
 --     an attribute only of V.)                                     
 -- Case 2:                                                          
 -- Case 1 does not apply; the attr is INIT(X)  ==>                  
 --   Discard X (separate rules for callmessages vs. others)         
 -- Case 3:                                                          
 -- Case 1 does not apply; the attr is CASE(V, V.X) ==>              
 --   Hide V                                                       
 -- Case 4:                                                          
 -- Case 1 does not apply; the attr is constraint(P1, ... Pn) ==>    
 --   DROP constraint(P1, ... Pn)                                    
 --                                                                  
 -- The rules for determining the Drops and PrerequisiteDrops        
 -- are described in the algorithm for each coercion                 
 -- Discard CM =>                                                    
 --  Prerequisite Drops: Attrs of CM where component is non-constant       
 --  Drops: Attributes of CM where component is constant                                         
 -- Discard Others =>                                                
 --  Prerequisite Drops: Attrs involving object except INIT(object)  
 --  Drops: INIT(Object)                                             
 -- Hide V =>                                                      
 --  Prerequisite Drops: Attrs involving V.X but not in Case TS      
 --  Drops: CASE(V, V.X) and CASE TS                                 
 -- Drop ATTR(P1, ... Pn)                                            
 --  Prerequisite Drops: Constraints with precondition ATTR(P1, ... Pn)
 --  Drops: ATTR(P1, ... Pn)                                         
  DECLARE
    FP: AttemptToCoerceCall ;
    Obj: Objectname; -- the first object in the attribute
    ComponentOrdinal: Integer; -- how many levels of components have been examined
    Type: Typename; -- the type of the object or object container being examined
    CM: Objectname; -- callmessage containing Obj
    V: Objectname; -- variant containing Obj
    VDotC: Objectname; -- component of V being hidden
    Nothing: Empty; -- what an optional thing is when it's not there
  BEGIN
    BLOCK
      BEGIN
        RECEIVE FP From AttemptToCoerceInit;
        NEW FP.Coercion;
        NEW FP.Coercion.Operands;
        Obj <- Objectname # (Object IN FP.DroppedAttribute.Objects WHERE(boolean # (integer # (POSITION OF Object) = integer # (0))));
        INSPECT RootScope IN FP.Declarations WHERE(boolean # (Obj.Root.Scope = Rootscope.Id))
          BEGIN
            BLOCK
              BEGIN
                INSPECT Declaration IN RootScope.Declarations WHERE(boolean # (Declaration.Id = Obj.Root.Root))
                  BEGIN
                    REVEAL Declaration.Typename.Typename;
                    Type := Declaration.Typename.Typename;
                  END INSPECT;
              ON (CaseError)
                INSPECT Declaration IN FP.Context.InferredDcls WHERE(boolean # (Declaration.Root = Obj.Root))
                  BEGIN
                    Type := Declaration.Type;
                  END INSPECT;
              END BLOCK;
          END INSPECT;
        BLOCK
          BEGIN
            ComponentOrdinal <- integer # (0);
            WHILE (boolean # (ComponentOrdinal < integer # (SIZE OF Obj.Components)))
              REPEAT
                INSPECT Module IN FP.Definitions WHERE(boolean # (Module.Id = Type.ModuleId))
                  BEGIN
                    INSPECT Definition IN Module.Type_Definitions WHERE(boolean # (Definition.Id = Type.TypeId))
                      BEGIN
                        SELECT (primitive_types # (CASE OF Definition.Specification))
                          WHERE (primitive_types # 'varianttype')
                            -- 1. Determine the minimum TS by substituting OBJ for * in the case typestate of the variant's component
                            -- 2. If Attribute is in that minimum TS, then
                            --   a. Coercion is to hide the variant 
                            --   b. Prerequisites are all attributes involving variant component, except those in corequisites
                            --   c. Corequisites are CASE(V, V.Component) and the attributes in minimum
                            REVEAL Definition.Specification.Variant_Info;
                            INSPECT VariantComponentSpec IN Definition.Specification.Variant_Info.Case_Mapping WHERE(boolean # (VariantComponentSpec.Component_id = ComponentId # (Component IN Obj.Components WHERE(boolean # (integer # (POSITION OF Component) = ComponentOrdinal)))))
                              BEGIN
                                NEW V;
                                V.Root := Obj.Root;
                                V.Components <- EVERY OF Component IN OBJ.Components WHERE(POSITION OF Component < ComponentOrdinal);
                                VDotC := V;
                                INSERT (ComponentId # (Component IN Obj.Components WHERE(boolean # (integer # (POSITION OF Component) = ComponentOrdinal)))) INTO VDotC.Components;
                                FP.Corequisites <- Typestate # (FP.Services.Substitute(FP.Services, VDotC, VariantComponentSpec.Case_Typestate)); 
                              END INSPECT;
                            IF boolean # (EXISTS OF Attr IN FP.Corequisites WHERE(boolean # (Attr = FP.DroppedAttribute)))
                              THEN
                                INSERT (EVALUATE CaseV_VDotC: Attribute FROM
                                  NEW CaseV_VDotC;
                                  UNITE CaseV_VDotC.Name.Case FROM EVALUATE Empty: Empty FROM END;
                                  NEW CaseV_VDotC.Objects;
                                  INSERT Objectname # (COPY OF V) INTO CaseV_VDotC.Objects;
                                  INSERT Objectname # (COPY OF VDotC) INTO CaseV_VDotC.Objects;
                                  END) INTO FP.Corequisites;
                                FP.Coercion.Operator <- operator # 'hide';
                                INSERT V INTO FP.Coercion.Operands;
                                FP.Prerequisites <- Typestate # (FP.Services.Involving(FP.CurrentTS, VDotC, FP.Corequisites));
                                EXIT Case1;
                              ELSE
                              END IF;
                          OTHERWISE
                          END SELECT;
                        INSPECT ComponentDeclaration IN Definition.Component_Declarations WHERE(boolean # (ComponentDeclaration.Id = ComponentId # (ComponentId IN Obj.Components WHERE(boolean # (integer # (POSITION OF ComponentId) = ComponentOrdinal)))))
                          BEGIN
                            Type := ComponentDeclaration.Type;
                          END INSPECT;
                        ComponentOrdinal <- integer # (ComponentOrdinal + integer # (1));
                      END INSPECT;
                  END INSPECT;
              END WHILE;
            -- Not case 1:  coercion depends upon attribute_type
            INSPECT Module IN FP.Definitions WHERE(boolean # (Module.Id = Type.ModuleId))
              BEGIN
                INSPECT Definition IN Module.Type_Definitions WHERE(boolean # (Definition.Id = Type.TypeId))
                  BEGIN
    		NEW FP.Corequisites;
    		INSERT Attribute # (COPY OF FP.DroppedAttribute) INTO FP.Corequisites;
                    FP.Prerequisites <- Typestate # (FP.Services.Involving(FP.CurrentTS, Obj, FP.Corequisites));
                    SELECT (Attribute_Type # (CASE OF FP.DroppedAttribute.Name))
                      WHERE (Attribute_Type # 'initialized')
                        IF boolean # (Primitive_Types # (CASE OF Definition.Specification) = Primitive_Types # ('callmessagetype'))
                          THEN
                            BLOCK
                            DECLARE
                              AttrsOfConstants: Typestate;  -- Attributes which involve constant subcomponents
                              BEGIN
                                REVEAL Definition.Specification.Callmessage_Info;
                                EXTRACT AttrsOfConstants FROM Attr IN FP.Prerequisites WHERE(EXISTS OF Object IN Attr.Objects WHERE(NOT EXISTS OF Constant IN Definition.Specification.Callmessage_Info.Constants WHERE((Component IN Object.Components WHERE(POSITION OF Component = 0)) = Constant)));
                                MERGE AttrsOfConstants INTO FP.Corequisites; 
                              END BLOCK;
                          END IF;
    		        FP.Coercion.Operator <- Operator # 'discard';
                        INSERT Obj INTO FP.Coercion.Operands;
                      WHERE (Attribute_Type # 'case')
                        VDotC <- ObjectName # (Object IN FP.DroppedAttribute.Objects WHERE(boolean # (integer # (POSITION OF Object) = integer # (1))));
                        REVEAL Definition.Specification.Variant_Info;
			INSPECT VariantComponentSpec IN Definition.Specification.Variant_Info.Case_Mapping WHERE(boolean # (VariantComponentSpec.Component_id = ComponentId # (Component IN VDotC.Components WHERE(boolean # (integer # (POSITION OF Component) = ComponentOrdinal)))))
			  BEGIN
    --        	        MERGE Typestate # (FP.Services.Substitute(FP.Services, VDotC, VariantComponentSpec.Case_Typestate)) INTO FP.Corequisites;
			    BLOCK
			      DECLARE
				CaseTS: Typestate;
				A: Attribute;
			      BEGIN
				CALL FP.Services.Substitute(FP.Services, VDotC, VariantComponentSpec.Case_Typestate, CaseTS);
				WHILE('true')
				  REPEAT
				    REMOVE A FROM Attr IN CaseTS WHERE('true');
				    BLOCK
				      BEGIN
					INSERT A INTO FP.Corequisites;
				      ON (DuplicateKey)
				      END BLOCK;
				  END WHILE;
			      ON (NotFound)
			      END BLOCK;
    
                          END INSPECT;
                        FP.Coercion.Operator <- Operator # 'hide';
                        INSERT Obj INTO FP.Coercion.Operands;
                        FP.Prerequisites <- Typestate # (FP.Services.Involving(FP.CurrentTS, VDotC, FP.Corequisites));
                      WHERE (Attribute_Type # 'constraint')
                        FP.Coercion.Operator <- Operator # 'drop';
                        FP.Coercion.Operands := FP.DroppedAttribute.Objects;
                        NEW FP.Prerequisites;
                        -- this code looks in FP.CurrentTS for constraints
                        -- whose pretypestate is FP.DroppedAttribute
                        -- It is omitted for now.
                      OTHERWISE -- should not occur
                        EXIT ShouldNotOccur;
                      END SELECT;
                  END INSPECT;
              END INSPECT;
          ON EXIT (Case1)
          END BLOCK;
        FP.Coercion.Id <- StatementId # (UNIQUE);
        UNITE FP.Coercion.Qualifier.Empty FROM Nothing;
        FP.Coercion.Prag <- charstring # "";
        RETURN FP;
      ON EXIT (ShouldNotOccur)
        PRINT charstring # "tsatc: should not occur";
      ON (Others)
        print charstring # "something went wrong with tsatc";
      END BLOCK;
  END PROCESS
