-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pomvts.p
-- Author: Rob Strom
-- SCCS Info: @(#)pomvts.p	1.2 3/13/90

pomvts : USING( tscheck, Predefined  ) PROCESS (PostMoveTSInit : DeterminePostconditionInport )
-- Compute Postcondition of MOVE
-- Algorithm:
-- 1. For each attribute involving source object, 
--    put that attribute in the Drops list
--    substitute destination object for source
--    put that attribute in the Adds list
-- 2. For each attribute involving destination object,
--    put that attribute in the Drops list unless it's in the Adds list
-- 3. Eliminate from both lists any attributes on both lists
--    
  DECLARE
    FP: DeterminePostconditionCall ;
    AttributesInvolvingSource : Typestate;
    AttributesInvolvingDestination : Typestate;
    EmptyAttributeList:  Typestate;
    DeletedAttribute: Attribute;
  BEGIN
    RECEIVE FP FROM PostMoveTSInit ;
    INSPECT SourceObject IN FP.Statement.Operands WHERE(POSITION OF SourceObject = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 0))
      BEGIN
        INSPECT DestinationObject IN FP.Statement.Operands WHERE(POSITION OF DestinationObject = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 1))
          BEGIN
            -- 1.
            NEW EmptyAttributeList; 
	    CALL FP.Services.Involving(FP.CurrentTS, SourceObject, EmptyAttributeList, AttributesInvolvingSource);
	    FOR Attribute IN AttributesInvolvingSource WHERE('true')
	      INSPECT
	        INSERT (EVALUATE TransformedAttribute : Attribute FROM
	          NEW TransformedAttribute;
	          TransformedAttribute.Name := Attribute.Name;
	          NEW TransformedAttribute.Objects;
	          FOR Object IN Attribute.Objects WHERE('true')
	            INSPECT
	              INSERT (EVALUATE TransformedObject : ObjectName FROM
	                IF (EVALUATE Substitutable : Boolean FROM
	                  Substitutable <- (Object.Root = SourceObject.Root) AND (SIZE OF Object.Components >= SIZE OF SourceObject.Components);
	                  IF Substitutable
	                    THEN
	                      Substitutable <- FORALL OF Component IN SourceObject.Components WHERE(Mate IN Object.Components WHERE(POSITION OF Mate = POSITION OF Component) = Component);
	                    END IF;
	                  END)
	                  THEN
	                    NEW TransformedObject;
	                    TransformedObject.Root := DestinationObject.Root;
	                    TransformedObject.Components := DestinationObject.Components;
	                    FOR Component IN Object.Components WHERE(POSITION OF Component >= SIZE OF SourceObject.Components)
	                      INSPECT
	                        INSERT COPY OF Component INTO TransformedObject.Components;
	                      END FOR;
	                  ELSE
	                    TransformedObject := Object;
	                  END IF;
	                END) INTO TransformedAttribute.Objects;
	            END FOR;
	          END) INTO FP.NormalPostcondition.Adds;
	      END FOR;
	    MERGE AttributesInvolvingSource INTO FP.NormalPostcondition.Drops;
	    -- 2.
	    CALL FP.Services.Involving(FP.CurrentTS, DestinationObject, EmptyAttributeList, AttributesInvolvingDestination);
	    WHILE (SIZE OF AttributesInvolvingDestination > 0)
	      REPEAT
	        REMOVE DeletedAttribute FROM Attribute IN AttributesInvolvingDestination WHERE('true');
	        IF EXISTS OF Mate IN FP.NormalPostcondition.Adds WHERE(Mate = DeletedAttribute)
	          THEN
	            DISCARD DeletedAttribute;
	          ELSE
	            INSERT DeletedAttribute INTO FP.NormalPostcondition.Drops;
	          END IF;
	      END WHILE;
	    -- 3. not done now -- only affects case where src/dst overlap
          END INSPECT;
      END INSPECT;
    RETURN FP;
  END PROCESS
