-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pomventts.p
-- Author: Rob Strom
-- SCCS Info: @(#)pomventts.p	1.2 3/13/90

pomventts : USING( tscheck, Predefined  ) PROCESS (PostMoveEntryTSInit : DeterminePostconditionInport )
-- Compute Postcondition of RECEIVE
-- Similar to MOVE, except that what is moved is the entry typestate
-- rather than a current typestate
-- (For now, ignore the subtleties of RECEIVE M FROM M.P;)
-- Algorithm:
-- 1. Get the entry formal typestate (message_typestate).
-- 2. Substitute the destination message object name into the formal typestate
-- 3. Put those attributes on the Adds list
-- 3a. For now, put INIT of destination message onto the Adds list.
--  (this only fails for sends of uninit objects)
-- 4. For each attribute involving destination object,
--    put that attribute in the Drops list unless it's in the Adds list
--    
  DECLARE
    FP: DeterminePostconditionCall ;
    PortType: TypeName; -- type of the input port
    MessageTypestate: Typestate; -- typestate of the message after RECEIVE
    AttributesInvolvingDestination : Typestate;
    EmptyAttributeList:  Typestate;
    DeletedAttribute: Attribute;
  BEGIN
    RECEIVE FP FROM PostMoveEntryTSInit ;
    INSPECT SourceObject IN FP.Statement.Operands WHERE(POSITION OF SourceObject = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 0))
      BEGIN
        INSPECT DestinationObject IN FP.Statement.Operands WHERE(POSITION OF DestinationObject = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 1))
          BEGIN
            NEW EmptyAttributeList; 
            -- 1.
	    PortType <- FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, SourceObject);
	    INSPECT Module IN FP.Definitions WHERE(Module.Id = PortType.ModuleId)
	      BEGIN
		INSPECT Definition IN Module.Type_Definitions WHERE(Definition.Id = PortType.TypeId)
		  BEGIN
		    -- 2.
		    REVEAL Definition.Specification.Inport_Info; 
		    CALL FP.Services.Substitute(FP.Services, DestinationObject, Definition.Specification.Inport_Info.Message_Typestate, MessageTypestate);
		    -- 3.
		    MERGE MessageTypestate INTO FP.NormalPostcondition.Adds;
		    -- 3a.
	            BLOCK
	              BEGIN
			INSERT (EVALUATE InitDest : Attribute FROM
			  NEW InitDest;
			  NEW InitDest.Objects;
			  UNITE InitDest.Name.Init FROM EVALUATE Nothing: Empty FROM END;
			  INSERT COPY OF DestinationObject INTO InitDest.Objects;
			  END) INTO FP.NormalPostcondition.Adds;
		      ON (DuplicateKey)
		      END BLOCK;
		  END INSPECT;
              END INSPECT;
	    -- 4.
	    CALL FP.Services.Involving(FP.CurrentTS, DestinationObject, EmptyAttributeList, AttributesInvolvingDestination);
	    WHILE (SIZE OF AttributesInvolvingDestination > 0)
	      REPEAT
	        REMOVE DeletedAttribute FROM Attribute IN AttributesInvolvingDestination WHERE('true');
	        IF EXISTS OF Mate IN FP.NormalPostcondition.Adds WHERE(Mate = DeletedAttribute)
	          THEN
	            DISCARD DeletedAttribute;
	          ELSE
	            INSERT DeletedAttribute INTO FP.NormalPostcondition.Drops;
	          END IF;
	      END WHILE;
          END INSPECT;
      END INSPECT;
    RETURN FP;
  END PROCESS
