-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pocall.p
-- Author: Rob Strom
-- SCCS Info: @(#)pocall.p	1.2 3/13/90

pocall : USING( tscheck, Predefined, pocall  ) PROCESS (PostCallInit : DetermineCallPostconditionInport )
-- procedure to determine the postconditions for call
-- Algorithm:
-- 1. Get the inport type specification
-- 2. Get the callmessage type specification
-- 3. For normal postcondition, and for each exception postcondition on interface
--   3.1. For every formal attribute in postcondition, but not in precondition,
--        substitute actuals and include in adds list
--   3.2. For every formal attribute in precondition, but not in postcondition,
--        substitute actuals and include in drops list
--   Optimize by copying the postcondition, and deleting each match as it
--   is encountered.
--   "Discarded" must be treated separately, because we expand this
--   exception in the definition, and we don't expand the others.
--   Treat this exception as if it said only "INIT(CM)"
-- 4. Additional postconditions:  Depletion, Disconnected, empty adds and drops

  DECLARE
    FP: DetermineCallPostconditionCall ;
    GetAddsDrops: GetAddsDropsOutport ; -- procedure to get adds/drops set given precondition and postcondition formals, and actual call
    CallportObject: ObjectName; -- the callport
    CallportType: TypeName; -- type of the callport
  BEGIN
    
    -- Procedure to use the difference between inport precondition and
    -- callmessage postcondition to compute an add-drops set
    GetAddsDrops <- GetAddsDropsOutport # (PROCEDURE OF program # PROCESS (GetAddsDropsInit: GetAddsDropsInport)
      DECLARE
        FP: GetAddsDropsCall;
        Postcondition: Formal_Typestate; -- copy of original postcondition
        PostAttribute: Formal_Attribute; -- attribute in postcondition which matches precondition
        FormalDrops: Formal_Typestate; -- attributes in precondition which don't match postcondition
      BEGIN
        RECEIVE FP FROM GetAddsDropsInit;
        Postcondition := FP.Postcondition;
        NEW FormalDrops;
        FOR PreAttribute IN FP.Precondition WHERE(boolean # 'true')
          INSPECT
            BLOCK
              BEGIN
                REMOVE PostAttribute FROM Attribute IN Postcondition WHERE(boolean # (Attribute = PreAttribute));
                DISCARD PostAttribute;
              ON (NotFound)
                INSERT Formal_Attribute # (COPY OF PreAttribute) INTO FormalDrops;
              END BLOCK;
          END FOR;
        NEW FP.AddDropSet;
	FP.AddDropSet.Adds <- Typestate # (FP.Services.SubstituteCallParameters(FP.Services, FP.Operands, FP.CallmessageComponents, Postcondition));
	FP.AddDropSet.Drops <- Typestate # (FP.Services.SubstituteCallParameters(FP.Services, FP.Operands, FP.CallmessageComponents, FormalDrops));
        RETURN FP;
      END PROCESS);
      
    RECEIVE FP FROM PostCallInit ;
    -- 1.
    CallportObject <- ObjectName # (Operand IN FP.Statement.Operands WHERE(boolean # (integer # (POSITION OF Operand) = integer # (0))));
    CallportType <- TypeName # (FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, CallportObject));
    INSPECT CPModule IN FP.Definitions WHERE(boolean # (CPModule.Id = CallportType.ModuleId))
      BEGIN
        INSPECT CPDefinition IN CPModule.Type_Definitions WHERE(boolean # (CPDefinition.Id = CallportType.TypeId))
          BEGIN
            REVEAL CPDefinition.Specification.Outport_info;
            INSPECT IPModule IN FP.Definitions WHERE(boolean # (IPModule.Id = CPDefinition.Specification.Outport_info.ModuleId))
              BEGIN
                INSPECT IPDefinition IN IPModule.Type_Definitions WHERE(boolean # (IPDefinition.Id = CPDefinition.Specification.Outport_info.TypeId))
                  BEGIN
                    REVEAL IPDefinition.Specification.Inport_info;
                    -- 2.
                    INSPECT CMModule IN FP.Definitions WHERE(boolean # (CMModule.Id = IPDefinition.Specification.Inport_info.Message_type.ModuleId))
                      BEGIN
                        INSPECT CMDefinition IN CMModule.Type_definitions WHERE(boolean # (CMDefinition.Id = IPDefinition.Specification.Inport_info.Message_type.TypeId))
                          BEGIN
                            REVEAL CMDefinition.Specification.Callmessage_Info;
    		            -- 3.
    		            FP.NormalPostcondition <- AddDropSet # (GetAddsDrops(FP.Services, FP.Declarations, FP.Context.InferredDcls, FP.Definitions, FP.Statement.Operands, CMDefinition.Component_Declarations, IPDefinition.Specification.Inport_info.Message_Typestate, CMDefinition.Specification.Callmessage_Info.Normal));
    		            NEW FP.ExceptionPostconditions;
    		            FOR UserException IN CMDefinition.Specification.Callmessage_Info.Exception_Specifications WHERE(boolean # 'true')
    		              INSPECT
    		                INSERT (EVALUATE AddDrop : LabelledAddDropSet FROM
    		                  NEW AddDrop;
    		                  UNITE AddDrop.ExceptionName.User FROM (EVALUATE ExceptionName: User_Exception FROM
    		                    NEW ExceptionName;
    		                    ExceptionName.Type := IPDefinition.Specification.Inport_info.Message_type;
    		                    ExceptionName.ExceptionId := UserException.ExceptionId;
    		                    END);
    		                  IF UserException.ExceptionId = CMDefinition.Specification.Callmessage_Info.Minimum
    		                    THEN
    		                      AddDrop.AddDropSet <- AddDropSet # (GetAddsDrops(FP.Services, FP.Declarations, FP.Context.InferredDcls, FP.Definitions, FP.Statement.Operands, CMDefinition.Component_Declarations,  IPDefinition.Specification.Inport_info.Message_Typestate, EVALUATE InitStar:Formal_Typestate FROM
    		                        NEW InitStar;
                                        insert evaluate InitStarAttr: Formal_Attribute FROM
	                                  NEW InitStarAttr;
	                                  UNITE InitStarAttr.Attribute_Name.Init FROM evaluate nothing: empty from end;
	                                  NEW InitStarAttr.Parameters;
	                                  INSERT EVALUATE Star: Component_List FROM
		                            NEW Star;
		                            END INTO InitStarAttr.Parameters;
	                                  END INTO InitStar;
                                        END));
    		                    ELSE
    		                      AddDrop.AddDropSet <- AddDropSet # (GetAddsDrops(FP.Services, FP.Declarations, FP.Context.InferredDcls, FP.Definitions, FP.Statement.Operands, CMDefinition.Component_Declarations,  IPDefinition.Specification.Inport_info.Message_Typestate, UserException.Post_Typestate));
    		                    END IF;
    		                  END) INTO FP.ExceptionPostconditions;
    		              END FOR;
    		            -- 4.
    		            -- Depletion
    		            INSERT (EVALUATE AddDrop: LabelledAddDropSet FROM
    		              NEW AddDrop;
    		              UNITE AddDrop.ExceptionName.Builtin FROM Builtin_Exception # 'Depletion';
    		              NEW AddDrop.AddDropSet;
    		              NEW AddDrop.AddDropSet.Adds;
    		              NEW AddDrop.AddDropSet.Drops;
    		              END) INTO FP.ExceptionPostconditions;
    		            -- Disconnected
    		            INSERT (EVALUATE AddDrop2: LabelledAddDropSet FROM
    		              NEW AddDrop2;
    		              UNITE AddDrop2.ExceptionName.Builtin FROM Builtin_Exception # 'Disconnected';
    		              NEW AddDrop2.AddDropSet;
    		              NEW AddDrop2.AddDropSet.Adds;
    		              NEW AddDrop2.AddDropSet.Drops;
    		              END) INTO FP.ExceptionPostconditions;
    		          END INSPECT;
    		      END INSPECT;
    		  END INSPECT;
              END INSPECT;
          END INSPECT;
      END INSPECT;
    RETURN FP;
  END PROCESS
