-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)infer.p	1.2 3/13/90 
-- This file contains Infer, the 'master' inference process that calls the 
-- the type inference functions:
-- sameas
-- casetypeof
-- matchinginportof
-- messagetypeof
-- elementtypeof

-- The type inference functions have signature: typename X definitions -> typename.  
infer: USING(predefined, infer)
PROCESS(SetupQ: SetupInferQueue)

DECLARE
    SetupM: SetupInferMessage;
    InferM: InferMessage;
    InferQ: InferQueue;
    InferC: InferCapa;
    sameasport: InferCapa;
    casetypeofport: InferCapa;
    matchinginportofport: InferCapa;
    messagetypeofport: InferCapa;
    elementtypeofport: InferCapa;

BEGIN
    NEW InferQ;
    CONNECT InferC TO InferQ;

    RECEIVE SetupM FROM SetupQ;

    sameasport <- PROCEDURE OF SetupM.load("sameas");
    casetypeofport <- PROCEDURE OF SetupM.load("casetypeof");
    matchinginportofport <- PROCEDURE OF SetupM.load("matchinginportof");
    messagetypeofport <- PROCEDURE OF SetupM.load("messagetypeof");
    elementtypeofport <- PROCEDURE OF SetupM.load("elementtypeof");

    -- provide an output port capacity to calling environment
    SetupM.infer_func <- InferC;  
    RETURN SetupM;
    
    WHILE 'true'   -- forever process messages
    REPEAT
        RECEIVE InferM FROM InferQ;
-- forward the call message to the appropriate function to process
        SELECT
    	    WHERE(InferM.function = 'sameas')
    	        SEND InferM TO sameasport;
       	    WHERE(InferM.function = 'casetypeof')
    	   	SEND InferM TO casetypeofport;
            WHERE(InferM.function = 'matchinginportof')
    	    	SEND InferM TO matchinginportofport;
    	    WHERE(InferM.function = 'messagetypeof')
    	    	SEND InferM TO messagetypeofport;
            WHERE(InferM.function = 'elementtypeof')
    	    	SEND InferM TO  elementtypeofport;
    	    OTHERWISE
print(charstring#"otherwise entered in infer.p.  ERROR");
    	END SELECT;  
    END WHILE;
END process

