-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)unixcmd.d	1.2 3/13/90

/*

sh is a main program which takes the command line and runs it in a unix
shell subprocess.  For example,

	hermi sh cal 1989

will print a 1989 calendar on whatever device std.terminal.putString is
bound to.

unixCmd is the process that does the real work; it takes a command and a
few capabilities, and returns the status from the command that it executed.
it's interface is specified in this file.

*/

unixCmd: using (predefined, unix, terminalIO) definitions

  unixCmd: callmessage (
    cmd: charstring,
    popen: unix!popen_function,
    pclose: unix!pclose_function,
    fgets: unix!fgets_function,
    putString: terminalIO!putStringFunc,
    status: integer
  ) constant (cmd, popen, pclose, fgets, putString)
    exit { init(cmd), init(popen), init(pclose), init(fgets), init(putString) }
    exception programException { full }
    exception cantExec  { init(cmd), init(popen), init(pclose), init(fgets), 
      init(putString) };

  unixCmdQ: inport of unixCmd { init(cmd), init(popen), init(pclose),
    init(fgets), init(putString) };
  unixCmdFunc: outport of unixCmdQ;

end definitions
