-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: rmanager.p
-- Author: David F. Bacon, Andy Lowry from Rob Strom
-- SCCS Info: @(#)rmanager.p	1.2 3/13/90

rManager: using (sysRManager, rManager, rmInternal)

process (initQ: rManagerInitQ)

declare
  initArgs: rManagerInit;	-- initialization call

  post: sysPostResourceQ;	-- post resource
  insert: sysInsertResourceQ;	-- insert a resource
  get: sysGetResourceQ;		-- get resource (copy)
  remove: sysGetResourceQ;	-- get resource (remove)
  delete: sysDeleteResourceQ;	-- delete resource
    
  postArgs: sysPostResource;
  insertArgs: sysInsertResource;
  getArgs: sysGetResource;
  removeArgs: sysGetResource;
  deleteArgs: sysDeleteResource;
    
  repository: resourceRepository;
  resource: resourceDescriptor;
    
begin
  receive initArgs from initQ;

  -- create service ports and repository
  new post; new insert; new get; new remove; new delete;
  new repository;
  -- create connections to service ports
  new initArgs.rManager;
  connect initArgs.rManager.post to post;
  connect initArgs.rManager.insert to insert;
  connect initArgs.rManager.get to get;
  connect initArgs.rManager.remove to remove;
  connect initArgs.rManager.delete to delete;

  return initArgs;
    
  -- field service requests
  while ('true') repeat
    select
	  
    event post
      -- add a (copy of a) resource to the repository
      receive postArgs from post;
      block begin
	new resource;
	resource.owner := postArgs.userName;
	resource.name := postArgs.resourceName;
	resource.resource := postArgs.resource;
	resource.access := postArgs.accessFunction;
	insert resource into repository;
	return postArgs;
      on (DuplicateKey)
	return postArgs exception duplicateName;
      on (others)
	discard postArgs;
      end block;
	    
	    
    event insert
      -- add a resource to the repository
      receive insertArgs from insert;
      block begin
	new resource;
	resource.owner := insertArgs.userName;
	resource.name := insertArgs.resourceName;
	resource.resource <- insertArgs.resource;
	resource.access := insertArgs.accessFunction;
	insert resource into repository;
	return insertArgs;
      on (DuplicateKey)
	insertArgs.resource <- resource.resource;
	return insertArgs exception duplicateName;
      on (others)
	discard insertArgs;
      end block;
	    
	  
    event get
      -- retrieve a (copy of a) resource from the repository    
      receive getArgs from get;
      block begin
	inspect entry in repository[getArgs.resourceName] begin
	  getArgs.resource <- entry.access(getArgs.userName,
	    copy of entry.resource, getArgs.parameter);
	end inspect;
	return getArgs;
      on (NotFound)
	return getArgs exception notFound;
      on (access.accessDenied)
	return getArgs exception accessDenied;
      on (others)
	discard getArgs;
      end block;
	    
	    
    event remove
      -- remove a resource from the repository and return it
      receive removeArgs from remove;
      block begin
	remove resource from repository[removeArgs.resourceName];
	removeArgs.resource <- resource.access(removeArgs.userName,
	  resource.resource, removeArgs.parameter);
	return removeArgs;
      on (NotFound)
	return removeArgs exception notFound;
      on (access.accessDenied)
	insert resource into repository;
	return removeArgs exception accessDenied;
      on (others)
	discard removeArgs;
      end block;
	    
    event delete
      -- delete a resource from the repository (only owner can do this)
      receive deleteArgs from delete;
      block begin
	remove resource from r in repository where
	    (r.owner = deleteArgs.userName and 
	      r.name = deleteArgs.resourceName);
	discard resource;
	return deleteArgs;
      on (NotFound)
	return deleteArgs exception notOwner;
      on (others)
	discard deleteArgs;
      end block;
	  
    otherwise
    end select;
  end while;
end process
   
