-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: chainedsysrm.p
-- Author: Andy Lowry
-- SCCS Info: @(#)chainedsysrm.p	1.2 3/13/90

-- Manages a collection of system-level resource managers and presents
-- them as a single unified resource manager

chainedSysRM: using (sysRManager, chainedRM) 
  
process (initQ: chainedSysRMInitQ)

declare
  initArgs: chainedSysRMInit;
    
  rmList: sysRMList;	       
  mainRM: sysRManager;

  postQ: sysPostResourceQ;	-- post resource
  insertQ: sysInsertResourceQ;	-- insert a resource
  getQ: sysGetResourceQ;	-- get resource (copy)
  removeQ: sysGetResourceQ;	-- get resource (remove)
  deleteQ: sysDeleteResourceQ;	-- delete resource
    
  postArgs: sysPostResource;
  insertArgs: sysInsertResource;
  getArgs: sysGetResource;
  removeArgs: sysGetResource;
  deleteArgs: sysDeleteResource;
  
begin
  new postQ; new insertQ; new getQ; new removeQ; new deleteQ;
    
  receive initArgs from initQ;
  new initArgs.rm;
  connect initArgs.rm.post to postQ;
  connect initArgs.rm.insert to insertQ;
  connect initArgs.rm.get to getQ;
  connect initArgs.rm.remove to removeQ;
  connect initArgs.rm.delete to deleteQ;

  rmList := initArgs.rmList;
    
  return initArgs;
    
  mainRM := rmList[0];
    
  while 'true' repeat
    select
	    
    event postQ
      receive postArgs from postQ;
      send postArgs to mainRM.post;
	    
    event insertQ
      receive insertArgs from insertQ;
      send insertArgs to mainRM.insert;
	    
    event getQ
      receive getArgs from getQ;
      block begin
	for rm in rmList[] inspect
	  block begin
	    call rm.get(getArgs.userName, getArgs.resourceName, 
	      getArgs.parameter, getArgs.resource);
	    return getArgs;
	    exit getDone;
	  on (sysGetResource.accessDenied)
	    return getArgs exception accessDenied;
	    exit getDone;
	  on (sysGetResource.notFound)
	    -- continue
	  on exit (getDone)
	    exit getDone;
	  on (others)
	    discard getArgs;
	    exit getDone;
	  end block;
	end for;
	return getArgs exception NotFound;
      on exit (getDone)
	-- done
      end block;
	    
    event removeQ
      receive removeArgs from removeQ;
      block begin
	for rm in rmList[] inspect
	  block begin
	    call rm.remove(removeArgs.userName, removeArgs.resourceName, 
	      removeArgs.parameter, removeArgs.resource);
	    return removeArgs;
	    exit removeDone;
	  on (sysGetResource.accessDenied)
	    return removeArgs exception accessDenied;
	    exit removeDone;
	  on exit (removeDone)
	    exit removeDone;
	  on (others)
	    discard removeArgs;
	    exit removeDone;
	  on (sysGetResource.notFound)
	    -- continue
	  end block;
	end for;
	return removeArgs exception NotFound;
      on exit (removeDone)
	-- done
      end block;
	    
    event deleteQ
      receive deleteArgs from deleteQ;
      send deleteArgs to mainRM.delete;
	    
    otherwise
    end select;
  end while;
end process
