-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: profsum.p
-- Author: David Bacon
-- SCCS Info: @(#)profsum.p	1.2 3/13/90

profsum: using (profile, main, common, string) linking(itoa, justify)
   
   process (q: main_q)
    
  declare
    args: main_intf;
    argv: charstringList;
    junk: charstring;
    proffile: charstring;
    profiles: profiles;
    operations: integer;
    total: integer;
    itoa: int2stringFn;
    justify: justifyFn;
    
  begin
    itoa := procedure of process itoa;
    justify := procedure of process justify;
    
    receive args from q;
    argv := args.argv;
    remove junk from argv[0];
    remove junk from argv[0];
    block begin
	remove proffile from argv[0];
      on (NotFound)
	proffile := "hprof";
      end block;
    
    total := 0;
    unwrap profiles from args.std.pathReadObj(proffile) { init };

    for profile in profiles[] inspect
	operations := 0;
	
	for count in profile.counts[] inspect
	    operations := operations + count;
	  end for;
	
	total := total + operations;
	
	call args.std.terminal.putString(justify(profile.name, -32));
	call args.std.terminal.putString(justify(itoa(profile.creates), 8));
	call args.std.terminal.putLine(justify(itoa(operations), 8));
      end for;
    
    call args.std.terminal.putLine(justify("--------", 48));
    call args.std.terminal.putLine(justify(itoa(total), 48));
    
    return args;
  end process
   
