-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)loadprog.d	1.4 3/13/90

loadprog: using (predefined, objectio, parse, posmap)
definitions

  loadProgIntf: callmessage (
    moduleName: charString,
    readObj: readObject_Func,
    program: program,
    links: linkedPrograms,
    defmaps: definitions_printmappings,
    procmaps: executable_printmappings,
    posmap: position_mappings,
    badmodule: charString
  ) constant (moduleName, readObj)
    exit { init(moduleName), init(readObj), full(program), init(links),
      init(defmaps), init(procmaps), init(posmap) }
    exception programNotFound { init(moduleName), init(readObj) }
    exception definitionInconsistent 
	{ init(moduleName), init(readObj), init(badmodule) }
    exception definitionNotFound 
	{ init(moduleName), init(readObj), init(badmodule) };

  loadProgQ: inport of loadProgIntf { init(moduleName), init(readObj) };
  loadProgFunc: outport of loadProgQ;

end definitions
