/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)cfunc.h	1.4 3/13/90 */

/*
 * this file describes the interface for pseudo-processes that are written in
 * C but executed by the interpreter.
 *
 * these functions may use all of the C-Hermes function calls to interpreter
 * operations except for the operations on ports and processes.  these
 * "programming-in-the-large" operations must be called indirectly with the
 * operations whose interfaces are described in this file.
 */

#ifndef cfunc_included

#include "cherm.h"


#define CProc(x) void x(current, sched) \
  pcb *current; \
  schedp sched;

#define ipswitch switch(current->ip)
#define gotostate(x) (current->ip = (x))

typedef schedblock *schedp;

typedef struct {
    void (*funcp)();		/* pointer to function implementing the */
				/*  process. */
    int size;			/* size in bytes of data area. */
    char *name;			/* name. */
    char *description;		/* short description of function. */

} cproc_entry;

/******************************************************************************
 *                   Programming-in-the-Large Operations                      *
 *****************************************************************************/

status c_new_inport( /* objectp Inport */ );
				/* creates a new inport.  returns FAILURE */
				/*  on Depletion */

status c_connect( /* objectp Outport, objectp Inport */ );
				/* connects Outport to Inport.  returns */
				/*  FAILURE when there are too many */
				/*  connections to Inport. */

predef_exception c_send( /* schedp sched, objectp Outport, objectp Msg */ );
				/* sends Msg on Outport.  returns Normal if */
				/*  ok, Disconnected if inport is gone, and */
				/*  Depletion on storage depletion. */

status c_receive( /* objectp Msg, objectp Inport */ );
				/* receive a message from a port.  returns */
				/*  SUCCESS if message received; returns */
				/*  FAILURE if inport is empty. */

void c_return( /* schedp sched, objectp Callmsg */ );
				/* returns the callmessage to the caller */

status c_empty( /* objectp Inport */ );
				/* returns SUCCESS if Inport has no messages, */
				/*  FAILURE if it does. */

void c_discard( /* schedp sched, objectp Obj */ );
				/* discards the object.  may revive some */
				/*  processes if it contains callmessages. */

/******************************************************************************
 *                      Scheduling Operations                                 *
 *****************************************************************************/

void c_wait( /* schedp sched, pcb *current, objectp Inport */ );
				/* puts the process in a wait on the Inport */
				/*  and causes it to be descheduled on return */
				/*  if there are no messages waiting on the */
				/*  port. */

void c_suspend( /* schedp sched */ );
				/* causes the process to be descheduled on */
				/*  return. */

void c_die( /* schedp sched */ );
				/* causes the process to be killed on return */

#endif
#define cfunc_included
