-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)getstring.p	1.2 3/13/90

getString: using (predefined, terminalIO, terminalInits, unix)
process (initQ: initGetStringQ)

declare
  init: initGetStringIntf;
  fgetc: fgetc_function;
  file: handle;
  charint: int;
  getStringQ: getStringQ;
  getString: getStringIntf;

begin
  receive init from initQ;
  fgetc := init.fgetc;
  file := init.file;
  new getStringQ;
  connect init.getString to getStringQ;
  return init;

  while boolean#'true' repeat
    receive getString from getStringQ;
    
    call fgetc(file, charint);
    if boolean#(charint < int#0) then
      return getString exception endOfInput;
    else
      new getString.string;
      while boolean#(boolean#(charint >= int#0) and  
        boolean#(char#(CONVERT of charint) <> char#'NL')) repeat
        insert char#(convert of charint) into getString.string;
        call fgetc(file, charint);
      end while;
      return getString;
    end if;
  end while;
end process
