-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)fmtstmt.p	1.3 3/13/90

FmtStmt : USING(AbsFormat)
PROCESS (FormatStatementInit : FormatStatementInport )
  DECLARE
    FP: FormatStatementCall ;
  BEGIN
    RECEIVE FP FROM FormatStatementInit;
    FP.FormatValue <- FP.Formatters.FormatOpcode(FP.Formatters, FP.Statement.Operator);
    MERGE " (" INTO FP.FormatValue;
    FOR Operand IN FP.Statement.Operands WHERE('true')
      INSPECT
	IF POSITION OF Operand > 0
	  THEN
	    INSERT ',' INTO FP.FormatValue;
	  END IF;
	MERGE FP.Formatters.FormatObject(FP.Formatters, FP.Declarations, FP.InferredDeclarations, FP.Definitions, FP.DefinitionsMap, FP.ExecutableMap, Operand) INTO FP.FormatValue;
      END FOR;
    INSERT ')' INTO FP.FormatValue;
    SELECT (CASE OF FP.Statement.Qualifier)
      WHERE ('literal')
        INSERT '[' INTO FP.FormatValue;
        REVEAL FP.Statement.Qualifier.Literal;
        MERGE COPY OF FP.Statement.Qualifier.Literal INTO FP.FormatValue;
        INSERT ']' INTO FP.FormatValue;
      OTHERWISE
      END SELECT;
    RETURN FP;
  END PROCESS
