-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)fmtfmlts.p	1.3 3/13/90

FmtFmlTS : USING(AbsFormat)
PROCESS (FormatFormalTypestateInit : FormatFormalTypestateInport )
-- procedure to format a formal typestate
-- algorithm:  format the typestate as:
--    "{" comma-separated list of formal attributes "}"
  DECLARE
    FP: FormatFormalTypestateCall ;
    first_element_written: boolean;
  BEGIN
    RECEIVE FP FROM FormatFormalTypestateInit;
    FP.FormatValue <- "{";
    first_element_written <- 'false';
    FOR FormalAttribute IN FP.FormalTypestate WHERE('true')
      INSPECT
        IF first_element_written
          THEN
            INSERT ',' INTO FP.FormatValue;
          ELSE
            first_element_written <- 'true';
          END IF;
        MERGE FP.Formatters.FormatFormalAttribute(FP.Formatters, FP.Definitions, FP.DefinitionsMap, FormalAttribute, FP.Type) INTO FP.FormatValue;
      END FOR;
    INSERT '}' INTO FP.FormatValue;
    RETURN FP;
  END PROCESS
