/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: tempstore.c */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)tempstore.c	1.5 3/13/90";
#endif

#include "stdnil.h"
#include "li.h"
#include "storage.h"

#define ARBSIZE 1

struct waste_struct { char waste[ARBSIZE]; };
#define WASTED (sizeof(struct waste_struct) - sizeof(char)*ARBSIZE)

#define tallocsize(bytecount) (bytecount + sizeof(talloc) - (ARBSIZE + WASTED))

typedef struct talloc_struct {
    struct talloc_struct *next;
    int size;
    char space[ARBSIZE];
} talloc;

static talloc *tlist = nil;

char *
tempalloc(size)
int size;
{
    talloc *t;

    t = (talloc *) getmain(tallocsize(size));

    t->next = tlist;
    t->size = size;
    tlist = t;

    return(t->space);
}

void
tempfree()
{
    talloc *dead;

    while (tlist isnt nil) {
	dead = tlist;
	tlist = tlist->next;
	freemain(dead, tallocsize(dead->size));
    }
}


/* for portable quickcell size allocation */
int
get_object_talloc_size()
{
    return(tallocsize(sizeof(object)));
}


/* for debugging */
status
tempcheck(ptr)
char *ptr;
{
    talloc *tptr, *l;
    talloc tstruct;

    tptr = (talloc *) (ptr - 
		       (((char *) tstruct.space) - ((char *) &tstruct)));

    l = tlist;
    while (l isnt nil) {
	if (l is tptr)
	  return(SUCCESS);
	l = l->next;
    }

    return(FAILURE);
}

