/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)list.yacc	1.4 3/13/90 */

/* Anything ending with '_list' is a possibly empty comma-separated */
/* list.  Anything ending with '_NElist' is a nonemtpy comma-separated */
/* list.  '_dotlist' and '_NEdotlist' are counterparts that use dots */
/* (periods) as element separators rather than commas */

case_declaration_list : empty
case_declaration_list : case_declaration_NElist
case_declaration_NElist : case_declaration ;
case_declaration_NElist : case_declaration_NElist ',' case_declaration ;


declaration_list :
	{ p_init_declaration_list(); }
	empty
	{ $$ = p_get_declaration_list(); } ;
declaration_list :
	{ p_init_declaration_list(); }
	declaration_NElist
	{ $$ = p_get_declaration_list(); } ;
declaration_NElist : declaration
	{ (void) p_add_declaration($1); } ;
declaration_NElist : declaration_NElist ',' declaration 
	{ (void) p_add_declaration($3); } ;

component_declaration_list : declaration_list
	{ $$ = $1; } ;

named_literal_list :
	{ p_init_enum_elements(); }
	empty
	{ $$ = p_get_enum_elements(); };
named_literal_list :
	{ p_init_enum_elements(); }
	named_literal_NElist
	{ $$ = p_get_enum_elements(); };
named_literal_NElist : named_literal
	{ p_add_enum($1); } ;
named_literal_NElist : named_literal_NElist ',' named_literal 
	{ p_add_enum($3); } ;

/* used for parm lists of call and function_reference */
expression_list : empty ;
expression_list : expression_NElist ;
expression_NElist : expression_NElist ',' expression
	{ p_add_callparm($3); } ;
expression_NElist : expression
	{ p_add_callparm($1); } ;

exception_name_list : empty
	{ $$ = (objectp) nil; } ;
exception_name_list : exception_name_NElist
	{ $$ = $1; } ;
exception_name_NElist : exception_name_NElist ',' exception_name
	{ $$ = p_merge_exceptions($1, $3); } ;
exception_name_NElist : exception_name
	{ $$ = p_merge_exceptions(nil, $1); } ;

exit_name_list : empty
	{ $$ = (objectp) nil; } ;
exit_name_list : exit_name_NElist
	{ $$ = $1; } ;
exit_name_NElist : exit_name_NElist ',' exit_name
	{ $$ = p_merge_exits($1, $3); } ;
exit_name_NElist : exit_name
	{ $$ = p_merge_exits(nil, $1); } ;

module_name_list : empty ;
module_name_list : module_name_NElist ;
module_name_NElist : module_name 
	{ p_mod_import($1); } ;
module_name_NElist : module_name_NElist ',' module_name 
	{ p_mod_import($3); } ;

link_name_list : empty ;
link_name_list : link_name_NElist ;
link_name_NElist : link_name_NElist ',' link_name 
	{ p_load_link($3); } ;
link_name_NElist : link_name 
	{ p_load_link($1); } ;

variable_name_list : empty ;
variable_name_list : variable_name_NElist ;
variable_name_NElist : variable_name_NElist ',' variable_name ;
variable_name_NElist : variable_name ;

formal_variable_list :
	{ p_init_formal_object_name_list(); }
	empty
	{ $$ = p_get_formal_object_name_list(); } ;
formal_variable_list :
	{ p_init_formal_object_name_list(); }
	formal_variable_NElist
	{ $$ = p_get_formal_object_name_list(); } ;
formal_variable_NElist : formal_variable_NElist ',' 
	formal_variable
	{ p_add_formal_object_name($3); } ;
formal_variable_NElist : formal_variable
	{ p_add_formal_object_name($1); } ;

base_variable_list : empty ;
base_variable_list : base_variable_NElist ;
base_variable_NElist : base_variable_NElist ',' base_variable ;
base_variable_NElist : base_variable ;

component_name_list : empty ;
component_name_list : component_name_NElist ;
component_name_NElist : component_name_NElist ',' component_name
	{ p_add_callmsg_constant($3); } ;
component_name_NElist : component_name
	{ p_add_callmsg_constant($1); } ;

mapping_list : empty 
	{ $$ = mapping_expression(nil); };
mapping_list : mapping_NElist 
	{ $$ = mapping_expression($1); };
mapping_NElist : mapping_NElist ',' mapping 
	{ $$ = combine_mappings($1, $3); };
mapping_NElist : mapping 
	{ $$ = $1; };

associated_pair_NElist : associated_pair ;
associated_pair_NElist : associated_pair_NElist ',' associated_pair ;

variable_pair_NElist : variable_pair_NElist ',' variable_pair ;
variable_pair_NElist : variable_pair ;

formal_variable_pair_NElist : formal_variable_pair ;
formal_variable_pair_NElist : formal_variable_pair_NElist ',' 
	formal_variable_pair ;

attribute_list : empty ;
attribute_list : attribute_NElist ;
attribute_NElist : attribute ;
attribute_NElist : attribute_NElist ',' attribute ;

formal_attribute_list : empty ;
formal_attribute_list : formal_attribute_NElist ;
formal_attribute_NElist : formal_attribute
	{ p_add_formal_attribute($1); } ;
formal_attribute_NElist : formal_attribute_NElist ',' formal_attribute 
	{ p_add_formal_attribute($3); } ;
