-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
disinternal: using (predefined,interpform,stdenv,listuff,disassembler)
  definitions
    dests: table of integer {init} keys(*);
    label: record (
	prog_name: predefined!charstring,
	line_base: predefined!charstring,
	label_base: predefined!charstring,
	exit_base: predefined!charstring,
	indentation: predefined!integer,
	max_blanks: predefined!integer,
	exits: predefined!exit_printmap,
	dests: dests
      );
    -- all the Fn's must be "procedure of"'s
    dis: record (
	pms: printmaps,
	label: label,
	operation: disoperationFn,
	opcode: disopcodeFn,
	operand: disoperandFn,
	qualifier: disqualifierFn,
	integer: disintegerFn,
	blanks: disblanksFn,
	unstuff: LIUnstuffFn
      );
    -- disoperant returns a charstring representation of an opcode
    disoperation: callmessage (
	dis: dis,
	operation: interpform!operation,
	rep: predefined!charstring
      )
    constant (operation)
    exit {full}
    exception Unsupported {full(dis),full(operation)};
    disoperationQ: inport of disoperation 
       {full(dis),full(operation)};
    disoperationFn: outport of disoperationQ;
    -- disopcode returns a charstring representation of an opcode
    disopcode: callmessage (
	opcode: interpform!opcode,
	rep: charstring
      )
    constant (opcode)
    exit {full}
    exception Unsupported {init(opcode)};
    disopcodeQ: inport of disopcode {init(opcode)};
    disopcodeFn: outport of disopcodeQ;
    -- disoperand returns a charstring representation of an operand
    disoperand: callmessage (
	dis: dis,
	operand: interpform!operand,
	rep: charstring
      )
    constant (operand)
    exit {full};
    disoperandQ: inport of disoperand {full(dis),init(operand)};
    disoperandFn: outport of disoperandQ;
    -- disqualifier returns a charstring representation of a qualifier
    disqualifier: callmessage (
	dis: dis,
	qualifier: interpform!qualifier,
	context: opcode,
	rep: predefined!charstring
      )
    constant (qualifier,context)
    exit {full}
    exception Unsupported {full(dis),full(qualifier),init(context)};
    disqualifierQ: inport of disqualifier 
       {full(dis),full(qualifier),init(context)};
    disqualifierFn: outport of disqualifierQ;
    disinteger: callmessage (
	integer: predefined!integer,
	rep: predefined!charstring
      )
    constant (integer)
    exit {full};
    disintegerQ: inport of disinteger {init(integer)};
    disintegerFn: outport of disintegerQ;
    disblanks: callmessage (
	count: predefined!integer,
	ret: predefined!charstring
      )
    constant (count)
    exit {full};
    disblanksQ: inport of disblanks {init(count)};
    disblanksFn: outport of disblanksQ;
  end definitions
