-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
disasm: using 
   (predefined,common,interpform,main,disassembler,loadprog,parse,
    listuff,unix,disinternal,posmap)
  process (Q: main_Q)
  declare
    args: main_Intf;
    stuffedprog: predefined!program;
    prog: interpform!prog;
    pms: disassembler!printmaps;
    disasm: predefined!charstring;
    poly: common!polymorph;
    LIUnstuff: LIUnstuffFn;
    loadProg: loadProgFunc;
    program: predefined!program;
    links: linkedPrograms;
    defmaps: predefined!definitions_printmappings;
    procmaps: predefined!executable_printmappings;
    posmaps: position_mappings;
    disassembler: disassemblerFn;
    diskname: charstring;
    message: charstring;
    liname: charstring;
  begin
    receive args from Q;
    -- Load the support programs
    loadProg <- loadProgFunc#(procedure of 
	   program#(args.std.pathload(charstring#"loadprog")));
    LIUnstuff <- LIUnstuffFn#(procedure of 
	   program#(args.std.pathload(charstring#"liunstuff")));
    disassembler <- disassemblerFn#(procedure of 
	   program#(args.std.pathload(charstring#"disassembler")));
    -- Disassemble each command line argument
    for basename in args.argv
	   where (boolean#(integer#(position of basename)>integer#1))
      inspect
	block
	  declare
	    badmodule: predefined!charString;
	  begin
	    call args.std.terminal.putString(basename | ":");
	    -- load the program
	    call args.std.terminal.putString(" load[" | basename | ".ao]");
	    block
	      begin
		call loadProg(basename,args.std.pathReadObj,
		    program,links,defmaps,procmaps,posmaps,badmodule);
	      on (loadProgIntf.programNotFound)
		call args.std.terminal.putLine(" ERRORS");
		call args.std.terminal.putString(basename);
		call args.std.terminal.putLine(".ao was not found.");
		exit badAbsprog;
	      on (loadProgIntf.definitionInconsistent)
		call args.std.terminal.putLine(" ERRORS");
		call args.std.terminal.putString(badModule);
		call args.std.terminal.putLine(
		    " was inconsistent with other definitions.");
		exit badAbsprog;
	      on (loadProgIntf.definitionNotFound)
		call args.std.terminal.putLine(" ERRORS");
		call args.std.terminal.putString(badModule);
		call args.std.terminal.putLine(".do was not found.");
		exit badAbsprog;
	      end block;
	    -- load the li
	      call args.std.terminal.putString(" load[" | basename | ".po]");
	    liname := basename;
	    merge charstring#".po" into liname;
	    poly <- args.std.pathReadObj(liname);
	    unwrap stuffedprog from poly { init, init(definitions_modules),
	      init(main_program), init(programs)};
	    prog <- LIUnstuff(stuffedprog);
	    -- setup for the call
	    -- print charstring#"Setup for the call";
	    new pms;
	    pms.execs := procmaps;
	    pms.defs := defmaps;
	    unite pms.progid.pid from processid#(copy of program.main_program);
	    -- disassemble
	    call args.std.terminal.putString(" disassemble");
	    disasm <- disassembler(prog,args.std,pms);

	    block
	      declare
		handle: unix!handle;
		ret: unix!int;
	      begin
		-- store the result
		call args.std.terminal.putString(" write[" | basename | ".li]");
		diskname <- ".li";
		merge charstring#(copy of basename) into diskname at integer#0;
		handle <-
		   args.unix.stdio.fopen(diskname,"w");
		ret <-
		   args.unix.stdio.fputs(disasm,handle);
		call args.unix.stdio.fclose(handle);
	      call args.std.terminal.putLine("");
	      on (others)
		call args.std.terminal.putLine(" ERRORS");
		call args.std.terminal.putLine("Couldn't write output file.");
	      end block;
	  on exit (badAbsprog)
	    -- just try the next one...
	  on (others)
	    call args.std.terminal.putLine(" ERRORS");
	    call args.std.terminal.putLine(
		"Unexpected error during disassembly.");
	  end block;
      end for;
    -- Return 
    return args;
  end process
