# (C) Copyright International Business Machines Corporation 23 January 
# 1990.  All Rights Reserved. 
#  
# See the file USERAGREEMENT distributed with this software for full 
# terms and conditions of use. 
# File: vars.awk
# Author: Andy Lowry
# SCCS Info: @(#)vars.awk	1.2 3/13/90

# This awk script converts a vars file specifing object names for an
# LI source module into a preprocessor header file containing
# definitions for all the names as data vector offsets.  A special
# name for the total size of the data vector is also defined.
BEGIN {
    objnum = 4 ;
}

/^[a-zA-Z]/ {
    print "#define " $1 " " objnum ;
    objnum++;
}

END {
    print ;
    print "#define Process_Size " objnum ;
}
      
