-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: makeopmap.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)makeopmap.pp	1.11 3/15/90

-- Run this program to generate opcode mappings for the Hermes code
-- generator.  The table is written (as a polymorph) to file
-- opmap.obj.

-- DIRECTMAP macro generates code to set up a DIRECT opcode mapping







-- TYPEDMAP macro generates code to set up a TYPED opcode mapping.
-- All mappings for a given Hermes opcode must appear together,
-- preceded by an invocation of INITTYPEDMAP naming the Hermes opcode
-- being mapped, and followed by an invocation of DONETYPEDMAP.
















-- ADHOCMAP macro generates code to set up an ADHOC opcode mapping.






makeOpMap: using (predefined, common, cgInternal, interpform, main)
process (Q: main_Q)
declare
  init: main_intf;
  map: opMap;
  entry: opMapEntry;
  tEntry: typedOpMapEntry;
  tMap: typedOpMap;
  poly: polymorph;
  empty: empty;
begin
  receive init from Q;
  new map;

  -- Build up the mapping table
  new entry; entry.hOP <- operator#'and'; unite entry.mapInfo.direct from interpform!opcode#'and'; insert entry into map;
  new entry; entry.hOP <- operator#'assert'; unite entry.mapInfo.direct from interpform!opcode#'assert'; insert entry into map;
  new entry; entry.hOP <- operator#'attributename'; unite entry.mapInfo.direct from interpform!opcode#'attributename'; insert entry into map;
  new entry; entry.hOP <- operator#'call'; unite entry.mapInfo.direct from interpform!opcode#'call'; insert entry into map;
  new entry; entry.hOP <- operator#'case'; unite entry.mapInfo.direct from interpform!opcode#'case'; insert entry into map;
  new entry; entry.hOP <- operator#'concatenate'; unite entry.mapInfo.direct from interpform!opcode#'concat'; insert entry into map;
  new entry; entry.hOP <- operator#'connect'; unite entry.mapInfo.direct from interpform!opcode#'connect'; insert entry into map;
  new entry; entry.hOP <- operator#'copy'; unite entry.mapInfo.direct from interpform!opcode#'copy'; insert entry into map;
  new entry; entry.hOP <- operator#'create'; unite entry.mapInfo.direct from interpform!opcode#'create'; insert entry into map;
  new entry; entry.hOP <- operator#'currentprogram'; unite entry.mapInfo.direct from interpform!opcode#'currentprogram'; insert entry into map;
  new entry; entry.hOP <- operator#'discard'; unite entry.mapInfo.direct from interpform!opcode#'discard'; insert entry into map;
  new entry; entry.hOP <- operator#'dissolve'; unite entry.mapInfo.direct from interpform!opcode#'dissolve'; insert entry into map;
  new entry; entry.hOP <- operator#'empty'; unite entry.mapInfo.direct from interpform!opcode#'empty'; insert entry into map;
  new entry; entry.hOP <- operator#'equal'; unite entry.mapInfo.direct from interpform!opcode#'equal'; insert entry into map;
  new entry; entry.hOP <- operator#'exit'; unite entry.mapInfo.direct from interpform!opcode#'exit'; insert entry into map;
  new entry; entry.hOP <- operator#'hide'; unite entry.mapInfo.direct from interpform!opcode#'hide'; insert entry into map;
  new entry; entry.hOP <- operator#'insert'; unite entry.mapInfo.direct from interpform!opcode#'insert'; insert entry into map;
  new entry; entry.hOP <- operator#'insert_at'; unite entry.mapInfo.direct from interpform!opcode#'insert_at'; insert entry into map;
  new entry; entry.hOP <- operator#'integer_literal'; unite entry.mapInfo.direct from interpform!opcode#'ilit'; insert entry into map;
  new entry; entry.hOP <- operator#'merge'; unite entry.mapInfo.direct from interpform!opcode#'merge'; insert entry into map;
  new entry; entry.hOP <- operator#'merge_at'; unite entry.mapInfo.direct from interpform!opcode#'merge_at'; insert entry into map;
  new entry; entry.hOP <- operator#'mod'; unite entry.mapInfo.direct from interpform!opcode#'imod'; insert entry into map;
  new entry; entry.hOP <- operator#'move'; unite entry.mapInfo.direct from interpform!opcode#'move'; insert entry into map;
  new entry; entry.hOP <- operator#'not'; unite entry.mapInfo.direct from interpform!opcode#'not'; insert entry into map;
  new entry; entry.hOP <- operator#'not_equal'; unite entry.mapInfo.direct from interpform!opcode#'notequal'; insert entry into map;
  new entry; entry.hOP <- operator#'or'; unite entry.mapInfo.direct from interpform!opcode#'or'; insert entry into map;
  new entry; entry.hOP <- operator#'print'; unite entry.mapInfo.direct from interpform!opcode#'print'; insert entry into map;
  new entry; entry.hOP <- operator#'procedure'; unite entry.mapInfo.direct from interpform!opcode#'procedure'; insert entry into map;
  new entry; entry.hOP <- operator#'real_literal'; unite entry.mapInfo.direct from interpform!opcode#'rlit'; insert entry into map;
  new entry; entry.hOP <- operator#'receive'; unite entry.mapInfo.direct from interpform!opcode#'receive'; insert entry into map;
  new entry; entry.hOP <- operator#'rem'; unite entry.mapInfo.direct from interpform!opcode#'irem'; insert entry into map;
  new entry; entry.hOP <- operator#'return'; unite entry.mapInfo.direct from interpform!opcode#'return'; insert entry into map;
  new entry; entry.hOP <- operator#'return_exception'; unite entry.mapInfo.direct from interpform!opcode#'return_exception'; insert entry into map;
  new entry; entry.hOP <- operator#'reveal'; unite entry.mapInfo.direct from interpform!opcode#'reveal'; insert entry into map;
  new entry; entry.hOP <- operator#'send'; unite entry.mapInfo.direct from interpform!opcode#'send'; insert entry into map;
  new entry; entry.hOP <- operator#'size'; unite entry.mapInfo.direct from interpform!opcode#'size'; insert entry into map;
  new entry; entry.hOP <- operator#'string_literal'; unite entry.mapInfo.direct from interpform!opcode#'chs_lit'; insert entry into map;
  new entry; entry.hOP <- operator#'type'; unite entry.mapInfo.direct from interpform!opcode#'type_of'; insert entry into map;
  new entry; entry.hOP <- operator#'typename'; unite entry.mapInfo.direct from interpform!opcode#'typename'; insert entry into map;
  new entry; entry.hOP <- operator#'typestate'; unite entry.mapInfo.direct from interpform!opcode#'typestate_of'; insert entry into map;
  new entry; entry.hOP <- operator#'unique'; unite entry.mapInfo.direct from interpform!opcode#'unique'; insert entry into map;
  new entry; entry.hOP <- operator#'unite'; unite entry.mapInfo.direct from interpform!opcode#'unite'; insert entry into map;
  new entry; entry.hOP <- operator#'unwrap'; unite entry.mapInfo.direct from interpform!opcode#'unwrap'; insert entry into map;
  new entry; entry.hOP <- operator#'wrap'; unite entry.mapInfo.direct from interpform!opcode#'wrap'; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'add'; new tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'integertype'; tEntry.liOp <- interpform!opcode#'iadd'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'realtype'; tEntry.liOp <- interpform!opcode#'radd'; insert tEntry into tMap;
    unite entry.mapInfo.typed from tMap; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'divide'; new tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'integertype'; tEntry.liOp <- interpform!opcode#'idivide'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'realtype'; tEntry.liOp <- interpform!opcode#'rdivide'; insert tEntry into tMap;
    unite entry.mapInfo.typed from tMap; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'greater'; new tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'integertype'; tEntry.liOp <- interpform!opcode#'igt'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'realtype'; tEntry.liOp <- interpform!opcode#'rgt'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'enumerationtype'; tEntry.liOp <- interpform!opcode#'oegt'; insert tEntry into tMap;
    unite entry.mapInfo.typed from tMap; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'greater_equal'; new tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'integertype'; tEntry.liOp <- interpform!opcode#'ige'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'realtype'; tEntry.liOp <- interpform!opcode#'rge'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'enumerationtype'; tEntry.liOp <- interpform!opcode#'oege'; insert tEntry into tMap;
    unite entry.mapInfo.typed from tMap; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'less'; new tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'integertype'; tEntry.liOp <- interpform!opcode#'ilt'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'realtype'; tEntry.liOp <- interpform!opcode#'rlt'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'enumerationtype'; tEntry.liOp <- interpform!opcode#'oelt'; insert tEntry into tMap;
    unite entry.mapInfo.typed from tMap; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'less_equal'; new tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'integertype'; tEntry.liOp <- interpform!opcode#'ile'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'realtype'; tEntry.liOp <- interpform!opcode#'rle'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'enumerationtype'; tEntry.liOp <- interpform!opcode#'oele'; insert tEntry into tMap;
    unite entry.mapInfo.typed from tMap; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'multiply'; new tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'integertype'; tEntry.liOp <- interpform!opcode#'imultiply'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'realtype'; tEntry.liOp <- interpform!opcode#'rmultiply'; insert tEntry into tMap;
    unite entry.mapInfo.typed from tMap; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'subtract'; new tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'integertype'; tEntry.liOp <- interpform!opcode#'isubtract'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'realtype'; tEntry.liOp <- interpform!opcode#'rsubtract'; insert tEntry into tMap;
    unite entry.mapInfo.typed from tMap; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'unary_minus'; new tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'integertype'; tEntry.liOp <- interpform!opcode#'inegate'; insert tEntry into tMap;
    new tEntry; tEntry.type <- predefined!primitive_types#'realtype'; tEntry.liOp <- interpform!opcode#'rnegate'; insert tEntry into tMap;
    unite entry.mapInfo.typed from tMap; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'block'; unite entry.mapInfo.adhoc from charstring#"cgblock"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'checkdefinitions'; unite entry.mapInfo.adhoc from charstring#"cgstmtstub"; insert entry into map;-- NYI
  new entry; entry.hOp <- predefined!operator#'convert'; unite entry.mapInfo.adhoc from charstring#"cgconvert"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'drop'; unite entry.mapInfo.adhoc from charstring#"cgstmtstub"; insert entry into map;	-- NYI
  new entry; entry.hOp <- predefined!operator#'every'; unite entry.mapInfo.adhoc from charstring#"cgevery"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'exists'; unite entry.mapInfo.adhoc from charstring#"cgexists"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'expression_block'; unite entry.mapInfo.adhoc from charstring#"cgexprblock"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'extract'; unite entry.mapInfo.adhoc from charstring#"cgextract"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'for_enumerate'; unite entry.mapInfo.adhoc from charstring#"cgforenum"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'for_inspect'; unite entry.mapInfo.adhoc from charstring#"cgforinsp"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'forall'; unite entry.mapInfo.adhoc from charstring#"cgforall"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'if'; unite entry.mapInfo.adhoc from charstring#"cgif"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'inspect_polymorph'; unite entry.mapInfo.adhoc from charstring#"cginsppoly"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'inspect_table'; unite entry.mapInfo.adhoc from charstring#"cginsptbl"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'named_literal'; unite entry.mapInfo.adhoc from charstring#"cgnamedlit"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'new'; unite entry.mapInfo.adhoc from charstring#"cgnew"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'position_of_element'; unite entry.mapInfo.adhoc from charstring#"cgposofelt"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'position_of_selector'; unite entry.mapInfo.adhoc from charstring#"cgposition"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'program_literal'; unite entry.mapInfo.adhoc from charstring#"cgproglit"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'remove'; unite entry.mapInfo.adhoc from charstring#"cgremove"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'select'; unite entry.mapInfo.adhoc from charstring#"cgselect"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'the_element'; unite entry.mapInfo.adhoc from charstring#"cgtheelement"; insert entry into map;
  new entry; entry.hOp <- predefined!operator#'while'; unite entry.mapInfo.adhoc from charstring#"cgwhile"; insert entry into map;
  -- wrap it up and store it away
  wrap map as poly;
  call init.std.WriteObj(charstring#"opmap.obj",poly);

  return init;
  
end process

