-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: analyzeselect.d
-- Author: Andy Lowry
-- SCCS Info: @(#)analyzeselect.d	1.2 3/13/90

-- Definitions for the analyzeSelect function, which decides how a
-- 'select' statement should be codegened and picks out all relevent
-- information

analyzeSelect: using (cgInternal) 

definitions

  analyzeSelect: callmessage (
      stmt: predefined!statement,
      cgData: cgData,
      strategy: selectStrategy
    )
    constant (stmt, cgData)
    exit {full};
  analyzeSelectQ: inport of analyzeSelect {full(stmt), full(cgData)};
  analyzeSelectFn: outport of analyzeSelectQ;

  -- selectStrategy is a prescription for translating a 'select' statement
  selectStrategyType: enumeration ('normal', 'jump', 'expr');
  selectStrategy: variant of selectStrategyType (
    'normal' -> normal: normalSelectStrategy {full},
    'jump' -> jump: jumpSelectStrategy {full},
    'expr' -> expr: exprSelectStrategy {full}
  );
  
  normalSelectStrategy: record (
    

end definitions

