-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- Tables to support typedef base types (see ctype.d)
-- Andy Lowry & David F. Bacon, Apr 1989

-- SCCS Info: @(#)typedef.d	1.2 3/13/90

typedef: using (predefined, cType) 
definitions

  -- Lookup a named type (defined with a typedef) by its name in a
  -- typedefs table
  typedefs: table of typedef { full } keys (name);

  typedef: record (
    name: charstring,
    type: cType
  );

/* note: we don't really handle qualifier-only typedefs like
	typedef long l;
	l int x;
	l float y;
   since the typedef will be assumed to mean 
	typedef long int l;
   however, this is such a hokey crock of a language feature that we are not
   going to worry our pretty little heads about it (now).  besides, K+R doesn't
   even mention it.
*/

end definitions
