/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* MiniC Symbol Table Structures
** Andy Lowry, Apr 1989
** SCCS Info: @(#)symtab.h	1.2 3/13/90
**/

/* We define structures for use in the MiniC parser symbol table.
** Typedef's for EXPR, CTYPE, and S_ENTRY must already exist (we
** define the structure to which S_ENTRY is typedef'ed here)
**/

typedef enum s_typecode {	/* codes for all the entry types */
  S_UNKNOWN,			/* no known type */
  S_VAR,			/* normal variable */
  S_FUNC,			/* function name */
  S_PARM,			/* parameter to a function */
  S_TYPEDEF,			/* user-defined typedef name */
  S_STRUCT,			/* tag on a structure definition */
  S_UNION,			/* tag on a union definition */
  S_ENUM,			/* tag on an enum definition */
  S_MEMBER,			/* a member in a struct or union */
  S_ECON			/* a named enumeration constant */
} S_TYPECODE;

typedef struct s_elist {	/* a list of s_entry structures */
  S_ENTRY *entry;		/* this entry on the list */
  struct s_elist *next;		/* tail of the list */
} S_ELIST;


typedef struct s_vardata {	/* data associated with a variable */
  CTYPE *type;			/* the type of the variable */
} S_VARDATA;

typedef struct s_fndata {	/* data associated with a function */
  CTYPE *type;			/* the (return) type of the function */
  S_ELIST *parms;		/* list of parameter entries */
  short nparm;			/* number of parameters */
} S_FNDATA;

typedef struct s_parmdata {	/* data associated with a function param */
  CTYPE *type;			/* the type of the parameter */
  S_ENTRY *fn;			/* which function it belongs to */
  short pno;			/* position in parameter list */
} S_PARMDATA;

typedef struct s_tdefdata {	/* data associated with a typedef */
  CTYPE *type;			/* the type represented by the typedef */
} S_TDEFDATA;

typedef struct s_sudata {	/* data associated with a struct/union */
  S_ELIST *members;		/* list of member declarations */
  short nmbr;			/* number of members */
} S_SUDATA;

typedef struct s_enmdata {	/* data associated with an enumeration type */
  S_ELIST *econs;		/* list of constituents */
  short necon;			/* number of constituents */
} S_ENMDATA;

typedef struct s_mbrdata {	/* data associated with a struct/union mbr */
  CTYPE *type;			/* type of the member */
  short fwid;			/* field width, -1 if not given */
  S_ENTRY *container;		/* struct/union of which this is a member */
} S_MBRDATA;

typedef struct s_econdata {	/* data associated with an enum constant */
  int value;			/* value associated with this name */
  S_ENTRY *class;		/* enumeration class to which this */
				/* constant belongs */
} S_ECONDATA;

typedef union s_entrydata {	/* type-dependent info associated with */
				/* symbol */ 
  S_VARDATA var;		/* each symbol type has its own structure */
  S_FNDATA fn;
  S_PARMDATA parm;
  S_TDEFDATA tdef;
  S_SUDATA su;			/* struct & union share a component */
  S_ENMDATA enm;
  S_MBRDATA mbr;
  S_ECONDATA econ;
} S_ENTRYDATA;

struct s_entry {		/* an entry in the symbol table */
  char *name;			/* name of symbol for this entry */
  S_TYPECODE type;		/* symbol type code */
  short level;			/* block nesting level of definition, */
				/* 0 means outer, -1 means not yet */
				/* known */ 
  short refcount;		/* number of things that point here */
  S_ENTRYDATA data;		/* type-dependent associated info */
}; 

