/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)cproctab.c	1.7 3/13/90 */

#define _BSD 43

#include <rpc/rpc.h>

#include "cfunc.h"

#include "parse.h"
#include "fdhandlers.h"

void C_cload();
void C_print();
void C_load();
void C_readobject();
void C_writeobject();
void C_access();
void C_store();

void C_stdio();
void C_read_external();
void C_stat_mtime();

void C_parsedef();
void C_parseproc();

void C_fdread();
void C_fdwrite();
void C_fdclose();
void C_window();

void C_start_network();
void C_set_linking_port();
void C_get_link();

/* C Process Table.  A nil function pointer indicates the end of the table. */

cproc_entry cproctab[] = {
    { C_cload, 0, "C Load", "C Process loader" },
				/* C processes are always looked up starting */
				/* in position 1, so this is mainly a place */
				/* holder. */
    { C_print, 0, "Print", "Polymorphic Hermes Object Printer" },
    { C_load, 0, "Load", "Load Program" },
    { C_store, 0, "Store", "Store Program" },
    { C_readobject, 0, "Read Object", "Read Polymorphed Object" },
    { C_writeobject, 0, "Write Object", "Write Polymorphed Object" },
    { C_stdio, 0, "Unix", "Unix System Caller (stdio)"},
    { C_access, 0, "Access", "Unix access(2) Function" },
    { C_read_external, 0, "Read External", "Read External Variable" },
    { C_stat_mtime, 0, "File Modification Time", "File Modification Time" },
    { C_parsedef, sizeof(feprocessdata), "Parse Def", "Parse Definition File"},
    { C_parseproc, sizeof(feprocessdata), "Parse Proc",
	"Parse Process File" },
    { C_fdread, sizeof(FDREADDATA), "FD Read", "File Descriptor Reader"},
    { C_fdwrite, sizeof(FDWRITEDATA), "FD Write", "File Descriptor Writer"},
    { C_fdclose, sizeof(FDCLOSEDATA), "FD Close", "File Descriptor Closer"},
    { C_window, 0, "Window", "Open a Display Window"},
    { C_start_network, 0, "start network", "Initialize inter-hermi RPC" },
    { C_set_linking_port, 0, "set linking port", "Initialize inport for RPC" },
    { C_get_link, 0, "get link", "Get outport for RPC" },
    { nil, 0, "Time", "Get Current Time as an Integer" },
    { nil, 0, nil, nil }
};


dfd_enumeration
lookup_cprocess(name)
char *name;
{
    dfd_enumeration pos;

    for (pos = 1; cproctab[pos].name isnt nil; pos++) 
      if (strcmp(cproctab[pos].name, name) is 0)
	return(pos);

    return(0);			/* zero indicates failure. */
}
