/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: actions.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)actions.ch	1.7 3/13/90";
#endif

#include <stdio.h>
#include <string.h>

#include "cherm.h"
#include "storage.h"

#include "asmfunc.h"
#include "asm.h"

#include "predefined.cd"
#include "interpform.cd"
#include "actions.cd"

extern objectp keyqual;		/* from cherm */

env *envp;

hobject(Operand, table);
hobject(Operandlist, table);

#define Prog envp->prog
#define Stmt envp->stmt
#define Labels envp->labels
#define Backpatch envp->backpatch
#define Exits envp->exits

#ifdef CHANGEOVER

#define code_objnew 20
#define operands_objnew 3
#define op_objnew 1
#define bp_objnew 2
#define sel_objnew 4
#define keyset_objnew 1

#else

#define code_objnew keyqual
#define operands_objnew keyqual
#define op_objnew keyqual
#define bp_objnew keyqual
#define sel_objnew keyqual
#define keyset_objnew keyqual

#endif

void
init_asm()
{
    void defmod_init(), link_init();

    envp = nil;
    defmod_init();
}


void
end_file(outerenv)
env *outerenv;
{
    extern char *filename;
    char outfile[128];
    lobject(File);		/* charstring */
    lobject(Absprog);		/* predefined!program */


    if (filename) {
	strcpy(outfile, "");
	strncat(outfile, filename, strcspn(filename, "."));
    }
    else
      strcpy(outfile, "a.out");

    strcat(outfile, ".po");
    chs_lit(File, outfile);

    new_program(Absprog);
    move(Absprog@program__LI_PROGRAM, outerenv->prog);
    write(Absprog, File);
}


objectp
new_object()
{
    objectp obj;

    obj = (objectp) malloc(sizeof(object));
    obj->tsdr = &dr_bottom;
    return(obj);    
}



void
init_proc(name, initport, envsize)
objectp initport;		/* predefined!typename: initport type */
int envsize;
char *name;
{
    env *oldenv;

    oldenv = envp;

    envp = new(env);
    Prog = new_object();	/* Prog == envp->prog */
    new_record(Prog, prog);
    unique(Prog@prog__id);
    ilit(Prog@prog__size, envsize);
    move(Prog@prog__type, initport);
    chs_lit(Prog@prog__name, name);
    vec_new_table(Prog@prog__linkedprogs, 0);
    vec_new_table(Prog@prog__code, code_objnew);

    envp->next = oldenv;

    Stmt = new_object();

    Labels = new_object();
    avl_new_table(Labels, firstelem_key);

    Backpatch = new_object();
    avl_new_table(Backpatch, firstelem_key);

    Exits = new_object();
    avl_new_table(Exits, firstelem_key);
}


env *
end_proc()
{
    hobject(Patchrec, record);	/* actions!backpatch_rec */
    env *oldenv;

    if (size_of(Backpatch) > 0) {
	fprintf(stderr, "The following labels were used but never defined:\n");

	initget(Patchrec, Backpatch, nil);
	while (get_or_err(Patchrec, Backpatch) is Normal)
	  fprintf(stderr, "  %s\n", stringval(Patchrec@backpatch_rec__label));
	endget(Patchrec, Backpatch);
    }

    oldenv = envp;
    envp = envp->next;

    return(oldenv);
}



void
init_stmt(opcode, label)
int opcode;
char *label;
{
    void labeldef();
    void init_operand_list();

    hobject(Stmtcopy, record);


    new_record(Stmt, operation);
    enum_lit(Stmt@operation__opcode, opcode);
    unite(Stmt@operation__qualifier, Bottom, qualifier_type__absent);

    init_operand_list();

    cheapcopy(Stmtcopy, Stmt);
    insert(Prog@prog__code, Stmtcopy);

    if (label) {
	labeldef(label);
    }
}


void
stmt_operand_list()
{
    move(Stmt@operation__operands, Operandlist);
}


void
init_operand_list()
{
    vec_new_table(Operandlist, operands_objnew);
}
    

void
add_operand()
{
    insert(Operandlist, Operand);
}


void
init_operand()
{
    vec_new_table(Operand, op_objnew);
}


void
add_component(offset)
int offset;
{
    hobject(Off, integer);

    ilit(Off, offset);
    insert(Operand, Off);
}


void
q_boolean(val)
dfd_boolean val;
{
    hobject(Value, boolean);

    h_boolean(Value, val);
    unite(Stmt@operation__qualifier, Value, qualifier_type__boolean);
}


void
q_integer(val)
dfd_integer val;
{
    hobject(Value, integer);

    ilit(Value, val);
    unite(Stmt@operation__qualifier, Value, qualifier_type__integer);
}


void
q_charstring(val)
char *val;
{
    hobject(Value, chs_table);

    chs_lit(Value, val);
    unite(Stmt@operation__qualifier, Value, qualifier_type__string);

    free_string(val);
}



void
q_proc(qualenv)
env *qualenv;
{
    hobject(Program, program);

    new_program(Program);
    move(Program@program__LI_PROGRAM, qualenv->prog);

    unite(Stmt@operation__qualifier, Program, qualifier_type__program);

    /* fix later: dispose of the env record */
}



void
q_label(name)
char *name;
{
    hobject(Val, integer);
    hobject(Ref, variant);

    copy(Ref, Bottom);		/* pre-init for unite (groan) */
    unite(Ref, Bottom, labelref_type__branch);
    ilit(Val, labelref(name, Ref));
    unite(Stmt@operation__qualifier, Val, qualifier_type__integer);
}


void
q_labelpair(name, num, labelpos)
char *name;
int num;
int labelpos;
{
    hobject(Lpair, record);
    hobject(Ref, variant);
    hobject(Pos, integer);

    new_record(Lpair, integer_pair);
    if (labelpos == 1)
      ilit(Lpair@integer_pair__int_two, num);
    else
      ilit(Lpair@integer_pair__int_one, num);

    copy(Ref, Bottom);		/* pre-init for unite (groan) */
    ilit(Pos, labelpos);
    unite(Ref, Pos, labelref_type__labelpair);
    if (labelpos is 1)
      ilit(Lpair@integer_pair__int_one, labelref(name, Ref));
    else
      ilit(Lpair@integer_pair__int_two, labelref(name, Ref));
    unite(Stmt@operation__qualifier, Lpair, qualifier_type__integer_pair);
}



void
init_selectlist()
{
    hobject(Sellist, table);

    vec_new_table(Sellist, sel_objnew);
    unite(Stmt@operation__qualifier, Sellist, qualifier_type__select);
}


void
add_selectlabel(name)
char *name;
{
    hobject(Ref, variant);
    hobject(Selpos, integer);
    hobject(Labval, integer);
    

    h_size(Selpos, Stmt@operation__qualifier@Component);
    copy(Ref, Bottom);
    unite(Ref, Selpos, labelref_type__select);

    ilit(Labval, labelref(name, Ref));
    insert(Stmt@operation__qualifier@Component, Labval);
}




#define STATEMENTNUM 	(size_of(Prog@prog__code)-1)

void
labeldef(name)
char *name;
{
    hobject(Label, record);
    hobject(Labname, chs_table);
    hobject(Zero, integer);
    hobject(Patch, record);
    hobject(FindPatch, record);
    hobject(St, record);
    hobject(Refst, record);
    hobject(Deadlabel, integer);
    hobject(Stnum, integer);
    hobject(Stcop, integer);
    hobject(Badhandler, record);

    new_record(Label, label_rec);
    chs_lit(Label@label_rec__label, name);
    ilit(Label@label_rec__statement, STATEMENTNUM);

    if (insert(Labels, Label) is DuplicateKey) {
	fprintf(stderr, "Label '%s' already defined.\n", name);
	return;
    }

    /* do the backpatching */

    chs_lit(Labname, name);
    ilit(Zero, 0);
    ilit(Stnum, STATEMENTNUM);

    if (h_lookup(FindPatch, Backpatch, Labname, 0) isnt NotFound) {
	fremove(Patch, FindPatch, Backpatch, PRIMARY_KEY);
	while (size_of(Patch@backpatch_rec__reflist) isnt 0) {
	    remove_at(Refst, Patch@backpatch_rec__reflist, Zero);
	    lookup_at(St, Prog@prog__code,
			      Refst@labelref_rec__statement);

	    switch (case_of(Refst@labelref_rec__ref)) {
	      case labelref_type__branch: {
		  copy(St@operation__qualifier@Component, Stnum);
		  break;
	      }

	      case labelref_type__labelpair: {
		  if (integerval(Refst@labelref_rec__ref@Component) is 1)
		    copy(St@operation__qualifier@Component@integer_pair__int_one,
			 Stnum);
		  else
		    copy(St@operation__qualifier@Component@integer_pair__int_two,
			 Stnum);
		  break;
	      }

	      case labelref_type__select: {
		  remove_at(Deadlabel, 
				    St@operation__qualifier@Component,
				    Refst@labelref_rec__ref@Component);
		  copy(Stcop, Stnum);
		  insert_at(St@operation__qualifier@Component, Stcop, 
				Refst@labelref_rec__ref@Component);
		  break;
	      }

	      case labelref_type__handler: {
		  h_lookup(Badhandler, St@operation__qualifier@Component,
			     Refst@labelref_rec__ref@Component, 0);
		  copy(Badhandler@block_handler__label, Stnum);
		  break;
	      }

	    }
	}
    }
}


int
labelref(name, Reftype)
char *name;
objectp Reftype;		/* constant labelref */
{
    hobject(Label, record);
    hobject(Labname, chs_table);
    hobject(Patch, record);
    hobject(Refrec, record);


    chs_lit(Labname, name);
    if (h_lookup(Label, Labels, Labname, 0) isnt NotFound) {
	discard(Reftype);
	return(integerval(Label@label_rec__statement));
    }

    /* label not found; put in backpatch */

    new_record(Refrec, labelref_rec);
    ilit(Refrec@labelref_rec__statement, STATEMENTNUM);
    move(Refrec@labelref_rec__ref, Reftype);

    if (h_lookup(Patch, Backpatch, Labname, 0) is NotFound) {
	new_record(Patch, backpatch_rec);
	chs_lit(Patch@backpatch_rec__label, name);
	vec_new_table(Patch@backpatch_rec__reflist, bp_objnew);
	insert(Patch@backpatch_rec__reflist, Refrec);
	insert(Backpatch, Patch);
    }
    else {
	insert(Patch@backpatch_rec__reflist, Refrec);
    }

    discard(Labname);

    return(-999);
}


q_exitid(name)
char *name;
{
    objectp addexit();

    unite(Stmt@operation__qualifier, addexit(name), qualifier_type__exit);
}


objectp
addexit(name)
char *name;
{
    hobject(Exname, chs_table);
    hobject(Exit, record);
    objectp Exid;		/* nominal */

    Exid = new_object();

    chs_lit(Exname, name);
    if (h_lookup(Exit, Exits, Exname, 0) isnt NotFound) {
	copy(Exid, Exit@exit_rec__exitid);
	return(Exid);
    }

    new_record(Exit, exit_rec);
    move(Exit@exit_rec__name, Exname);
    unique(Exit@exit_rec__exitid);

    copy(Exid, Exit@exit_rec__exitid);

    insert(Exits, Exit);

    return(Exid);
}

void
q_exception(Userex)
objectp Userex;			/* predefined!user_exception */
{
    unite(Stmt@operation__qualifier, Userex, qualifier_type__exception);
}



void
q_intpair(int1, int2)
int int1, int2;
{
    hobject(Pair, record);

    new_record(Pair, integer_pair);
    ilit(Pair@integer_pair__int_one, int1);
    ilit(Pair@integer_pair__int_two, int2);

    unite(Stmt@operation__qualifier, Pair, qualifier_type__integer_pair);
}


objectp
ex_others()
{
    objectp Handlername;

    Handlername = new_object();
    unite(Handlername, Bottom, handler_type__others);

    return(Handlername);
}


objectp
ex_exit(name)
char *name;
{
    objectp addexit();

    objectp Handlername;


    Handlername = new_object();
    unite(Handlername, addexit(name), handler_type__exit);

    return(Handlername);
}


objectp
ex_builtin(excepnum)
int excepnum;
{
    hobject(Excep, enumeration);
    objectp Handlername;

    enum_lit(Excep, excepnum);
    Handlername = new_object();
    unite(Handlername, Excep, handler_type__builtin);

    return(Handlername);
}


objectp
ex_user(Userex)
objectp Userex;
{
    objectp Handlername;

    Handlername = new_object();
    unite(Handlername, Userex, handler_type__user);
    return(Handlername);
}


void
init_handlers()
{
    hobject(Handlers, table);

    avl_new_table(Handlers, firstelem_key);
    unite(Stmt@operation__qualifier, Handlers, qualifier_type__block);
}


void
add_handler(Exception, lab)
objectp Exception;
char *lab;
{
    hobject(Ref, variant);
    hobject(Excopy, variant);
    hobject(Handler, record);


    copy(Excopy, Exception);
    copy(Ref, Bottom);
    unite(Ref, Excopy, labelref_type__handler);

    new_record(Handler, block_handler);
    move(Handler@block_handler__handler, Exception);
    ilit(Handler@block_handler__label, labelref(lab, Ref));

    insert(Stmt@operation__qualifier@Component, Handler);
}



void
q_table(nonlookrep, lookupinfo)
int nonlookrep;
objectp lookupinfo;
{
    hobject(Ninfo, record);

    new_record(Ninfo, new_table_info);

    if (nonlookrep isnt -1) {
	unite(Ninfo@new_table_info__nonlookup, Bottom, nonlookrep);
    }
    else {
	unite(Ninfo@new_table_info__nonlookup, Bottom, table_rep_type__none);
    }

    if (lookupinfo) {
	unite(Ninfo@new_table_info__opt_reps, lookupinfo, option__present);
    }
    else {
	unite(Ninfo@new_table_info__opt_reps, Bottom, option__absent);
    }

    unite(Stmt@operation__qualifier, Ninfo, qualifier_type__new_table);
}


objectp Tblreps;

void
init_tblreps()
{
    Tblreps = new_object();

    vec_new_table(Tblreps, Bottom);
}


objectp
get_tblreps()
{
    return(Tblreps);
}


void
add_tblrep(repnum)
int repnum;
{
    hobject(Rep, variant);

    copy(Rep, Bottom);  unite(Rep, Bottom, repnum);
    insert(Tblreps, Rep);
}

objectp
q_lookupinfo(Replist, Keyset, Indexset)
{
    objectp Linfo;

    Linfo = new_object();
    new_record(Linfo, lookup_info);

    move(Linfo@lookup_info__reps, Replist);
    move(Linfo@lookup_info__keys, Keyset);
    move(Linfo@lookup_info__indices, Indexset);

    return(Linfo);
}

objectp Lookupset;

void
q_init_lookupset()
{
    Lookupset = new_object();
    vec_new_table(Lookupset, keyset_objnew);
}

objectp 
q_get_lookupset()
{
    return(Lookupset);
}

void
q_add_lookup()
{
    if (size_of(Operandlist) > 0)
      insert(Lookupset, Operandlist);
}


void
q_typename(type)
objectp type;
{
    unite(Stmt@operation__qualifier, type, qualifier_type__typename);
}



char *
copystring(src)
char *src;
{
    char *newstring;


    newstring = (char *) getmain((counter) strlen(src)+1);
    strcpy(newstring, src);
    return(newstring);
}


void
free_string(str)
char *str;
{
    if (str)
      freemain(str, (counter) strlen(str)+1);
}


