/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1994  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.7 of 15-Sep-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * macros.h ---	macro definitions for the portable forth environment
 * (duz 09May93)
 */

#ifndef __MACROS_H
#define __MACROS_H

#ifndef __SYSDEP_H
#include "config.h"
#endif

#ifndef CHAR_BIT
#include <limits.h>
#endif

/* determines the dimension of any given vector */
#define DIM(X)		(sizeof (X) / sizeof *(X))
/* wipe any given vector X */
#define ZERO(X)		(memset ((X), 0, sizeof (X)))
/* copy any given vector Y to X */
#define COPY(X,Y)	(memcpy ((X), (Y), sizeof (X)))
/* allocate N items of arbitrary type and assign the pointer to them to P */
#define NEW(P,N)	((P) = malloc (sizeof *(P) * (N)))
/* return the byte offset of a given component to beginning of structure: */
#define OFFSET_OF(T,C)	((char *)&(((T *)0)->C) - (char *)0)

/* inc/decrement, push/pop of arbitrary types with arbitrary pointers */
#if 0 && defined __GNUC__ && !defined __cplusplus
/* Use non-ANSI extensions avoiding address-of operator: */
#define INC(P,T)	(((T *)(P))++)
#define DEC(P,T)	(--((T *)(P)))
#define ADD(P,N)	((char *)(P) += (N))
#else
/* Force (or fool) ANSI-C to do typecast's it normally refuses by */
/* casting pointers, not objects, then reference the casted pointers: */
#define INC(P,T)	((*(T **)&(P))++)
#define DEC(P,T)	(--(*(T **)&(P)))
#define ADD(P,N)	(*(char **)&(P) += (N))
#endif

#define POP(T,P,X)	((X) = *INC (P, T))
#define PUSH(T,X,P)	(*DEC (P, T) = (X))

/* useful shortcuts */

#ifdef OLDCPP
#define code(X)		void X/**/_(void)	/* declare a primitive */
#else
#define code(X)		void X##_(void)		/* declare a primitive */
#endif
#define Code(X)		static code (X)		/* declare a local primitive */

#define NFA		(to_name (w))
#define CFA		(w)
#define PFA		((Cell *)&w [1])

#define	FLAG(X)		((X) ? TRUE : FALSE)

#define BITSOF(X)	((int)(sizeof (X) * CHAR_BIT))
#define CELLBITS	BITSOF (Cell)
#define HALFCELL	(BITSOF (Cell) >> 1)
#define HIGHBIT(X)	((X) >> (BITSOF (X) - 1))

#define CELL_MAX	((Cell)((uCell)-1 >> 1))
#define UCELL_MAX	((uCell)-1)

#define RP		((Cell *)rp)
#define RPUSH(X)	PUSH (Cell, X, rp)
#define RPOP(X)		POP (Cell, rp, X)
#define	BRANCH		ADD (ip, *(Cell *)ip)
#define SKIP_STRING	ADD (ip, aligned (*(Byte *)ip + 1))
#define ALIGNED(P)	(((size_t)(P) & (CELL_ALIGN - 1)) == 0)
#define DFALIGNED(P)	(((size_t)(P) & (DFLOAT_ALIGN - 1)) == 0)
#define SFALIGNED(P)	(((size_t)(P) & (SFLOAT_ALIGN - 1)) == 0)

#define PAD		((char *)DP + MIN_HOLD)
#define	DEPTH		(memtop.stk - sp)
#define	COMMA(X)	(*(Cell *)DP = (Cell)(X), INC (DP, Cell))
#define FCOMMA(F)	(*(double *)DP = (F), INC (DP, double))

#define EXECUTE(X)	(w = (Xt)(X), call_word ())

#define UDDOTR(UD,W,BUF) outs (str_ud_dot_r (UD, &(BUF)[sizeof (BUF)], W,BASE))
#define DDOTR(D,W,BUF)	outs (str_d_dot_r (D, &(BUF) [sizeof (BUF)], W, BASE))
#define DOT(N,BUF)	outs (str_dot (N, &(BUF) [sizeof (BUF)], BASE))

/* long <-> dCell conversion macros, won't work on 16 bit machines */
#define UL2UDC(UL, UDC)	((UDC).hi = 0, (UDC).lo = (UL))
#define UDC2UL(HI, LO)	(LO)

/* Given a Cell or dCell these macros access the half cell components of it: */

#define	W0(X)		(((Cell_map *)&(X))->hi)
#define	W1(X)		(((Cell_map *)&(X))->lo)

#define	D0(X)		W0((X).hi)
#define	D1(X)		W1((X).hi)
#define	D2(X)		W0((X).lo)
#define	D3(X)		W1((X).lo)

#define CELL(W0,W1)	((Cell)(W0) << HALFCELL | (W1))

#endif /* __MACROS_H */
