;; Eulisp Module
;; Author: pab
;; File: instructions.em
;; Date: Fri Dec  6 00:40:15 1991
;;
;; Project:
;; Description: 
;;   List of instructions generated by the compiler
;;





	  
	  








	  


	  
	  



	  
	  





	  








	  



	  




	  
	  




	
























(defmodule instruct
  (standard0
   list-fns
   scan-args

   i-macros
   )
  ()
  
  ;; Do this with structures in the hope that some 
  ;; optimisation may be possible.
  
  ;; abstract class
  ;; 

  (defstruct instruction-info ()
    ((in initarg in
	       accessor instruction-in-count)
     (out initarg out
		accessor instruction-out-count)
     (stackop initarg stackop
	      initform ()
	      accessor instruct-stack-op)
     (branchp initarg branch
	      initform nil
	      accessor instruction-branchp)
     (sidep initarg side
	    initform nil
	    accessor instruction-sidep)
     (jumpp initarg jump
	    initform nil
	    accessor instruction-jumpp)
     (bytecode initarg bytecode
	       accessor instruction-bytecode)
     (name initarg name
	   accessor instruction-name)
     (nargs initarg nargs
	   accessor instruction-nargs)
     (null initform ()
	   initarg nullp
	   accessor instruction-nullp)
     (argwidth initform ()
	       initarg argtypes
	       accessor instruction-argtypes)
     (cost-fn initform nil
	      initarg cost-fn
	      accessor instruct-cost-fn)
     (cost-lit initform 1
	       initarg cost
	       reader instruct-cost-lit))
    constructor make-instruction
    predicate instruction-p)
  
  (export instruction-in-count instruction-out-count instruction-branchp 
	  instruction-sidep instruction-jumpp
	  instruction-bytecode  instruction-name 
	  instruction-nargs instruction-argtypes)
  (defconstant *no-val* '%%**%%)

  (defstruct instruction ()
    ((info initarg info
	   accessor i-info)
     (args initarg args
	   initform *no-val*
	   accessor i-args)
     (prev initform nil
	   accessor instruction-prev))
    )


  (defun i-nargs (x)
    (instruction-nargs (i-info x)))

  (defun i-inumber (x)
    (instruction-bytecode (i-info x)))

  (defun i-name (x) 
    (instruction-name (i-info x)))
  
  (defun i-arg-ref (x n)
    (vector-ref (i-args x) n))
  
  (defun i-link-data (x)
    (i-arg-ref x 0))
  
  (defun i-arg-list (x)
    (convert (i-args x) pair))
  
  (defun i-cost (i) 
    (let ((inf (i-info i)))
      (if (null (instruct-cost-fn inf))
	  (instruct-cost-lit inf)
	((instruct-cost-fn inf) i))))

  (export i-cost)

  (defun mk-imaker (name number props)
    (let ((nargs (scan-args 'nargs props 0)))
      (let ((istruct (apply make-instruction
			    'name name 
			    'bytecode number
			    'nargs nargs
			    props)))
	(cons istruct
	      (lambda (x)
		(make-instance instruction 'info istruct
			       'args (convert x vector)))))))
  
  (export i-info i-arg-ref i-name i-nargs i-args
	  i-inumber mk-imaker i-link-data i-arg-list)


  (defmethod generic-prin ((x instruction) stream)
    (format stream "$<~a" (i-name x))
    (mapcar (lambda (a) 
	      (format stream " ~a" a))
	    (convert (i-args x)
		     pair))
    (prin ">" stream))

  ;; NB. I assume label fn's first arg is the label
  ;; Really do need a nice way of doing this junk...
  (defun instruction-label (x)
    (vector-ref (i-args x) 0))

  ((setter setter) instruction-label
   (lambda (x y)
     ((setter vector-ref) (i-args x) 0 y)))

  (defun is-label-arg (arg)
    (eq arg 'label))

  (defun is-label (i)
    (eq (i-info i) i-label-info))
  
  (defun is-branch-arg (arg)
    (eq arg 'branch))

  (defun is-link-arg (arg)
    (eq arg 'link))

  (defun is-static-arg (arg)
    (eq arg 'static))
  
  (defun is-null-op (x)
    (instruction-nullp (i-info x)))

  (defun instruction-argwidth (i)
    (mapcar argsize
	    (instruction-argtypes i)))

  (export instruction-label is-label
	  is-branch-arg is-label-arg is-link-arg is-static-arg
	  is-null-op instruction-argwidth)
  
  (defun argsize (x)
    (if (numberp x)
	x
      (cond ((eq x 'label) 4)
	    ((eq x 'static) 4)
	    ((eq x 'link) 8)
	    ((eq x 'branch) 4)
	    (t (error "Unknown size" clock-tick)))))

  ;; Label abstraction...
  (defconstant lab-counter (mk-counter 0))
  
  (defstruct label ()
    ((lab-id initform (lab-counter)
	     reader label-id)
     (installed initform nil
		accessor label-installed)
     (lab-refs initform nil
	       initarg refs
	       accessor lab-refs))
    constructor (make-label x)
    constructor (make-reffed-label-1 refs))

  (defun make-refed-label () (make-reffed-label-1 '(1)))

  (defmethod generic-prin ((x label) stream)
    (format stream "#<lab: ~a>" (label-id x)))
  
  (defun add-lab-ref (lab ref)
    ((setter lab-refs) lab (cons ref (lab-refs lab))))
  
  (export make-label add-lab-ref lab-refs make-refed-label)
  
  ;; for inline-assembler....
  
  (defconstant find-instruction (mk-finder))
  (export find-instruction)

  (defun add-instruction (x val)
    ((setter find-instruction) x val))

  ;; For pre-linked code
  (defstruct inline-code-list ()
    ((count initarg count reader inline-code-count)
     (code initarg code reader inline-code))
    constructor (make-inline-code count code)
    predicate is-inline-code)
  
  (export inline-code-list inline-code-count inline-code make-inline-code
	  is-inline-code)
  ;; Each instruction in turn......
  ;; definstruction defines+exports aconstructor named by the instruction, 
  ;; plus <instruction>-info, the relavant info instance

  ;; hanging around instructions
  (definstruction nop 0 in 0 out 0)

  ;; shoving stuff on the stack
  
  (definstruction push-global 1 nargs 1 in 0 ;; args: module, index as pair
    out 1 argtypes (link) cost 4)
  (definstruction push-special 3 nargs 1 ;; args: name of special
    in 0 out 1 argtypes (link) cost 2) 
  (definstruction push-static 4 nargs 1 in 0 out 1 argtypes (static) cost 2) ;;       reference no.
  (definstruction push-fixnum 5 nargs 1 in 0 out 1 argtypes (4) cost 2) ;; could get away with less...
  
  (definstruction set-global 6 in 1 out 0 side t argtypes (static) cost 2) ;; args: index 
  ;; Stack reference
  (definstruction nth-ref 7 nargs 1 in 0 out 1 argtypes (1) stackop t)
  (definstruction set-nth 8 nargs 1 in 2 out 0 side t argtypes (1) stackop t)
  ;; stack abuse,  ;; depth of slide, keep
  (definstruction i-slide-stack 9 nargs 2 in arg-1 out arg-2 argtypes (1 1) stackop t)
  (definstruction swap 10 in 2 out 2 cost 1 stackop t)
  (definstruction drop 11 nargs 1 in arg-1 out 0 argtypes (1) stackop t) ;; equiv to (slide-stack n 0)
  
  ;; Environment hacking --- assumed to be TOS
  (definstruction env-ref 12 nargs 2 in 1 out 1 argtypes (1 1) cost 2) ;; depth, dist
  ;; depth, dist, returns new env
  (definstruction set-env 13 nargs 2 in 2 out 1 side t argtypes (1 1) cost 2)
  (definstruction make-env 15 nargs 1 in 1 out 1 argtypes (1) cost 3) ;; size
  (definstruction pop-env 14 nargs 1 in 1 out 1 argtypes (1) cost 2) ;; how far to drop

  ;; Object reference 
  (definstruction vref 16 in 2 out 1 cost 1)
  (definstruction set-vref 17 in 3 out 1 side t cost 2)
  (definstruction slot-ref 18 nargs 1 in 1 out 1 argtypes (1) cost 2)
  (definstruction set-slot 19 nargs 1 in 2 out 1 side t argtypes (1) cost 2)

  (definstruction i-set-type 20 in 1 out 1 side t cost 2)

  ;; Branches and jumps
  (definstruction branch 21 nargs 1 in 0 out 0 branch t conditional t argtypes (branch)) ;; local-label
  (definstruction branch-nil 22 nargs 1 in 0 out 0 branch t conditional t argtypes (branch)) ;; local label

  ;; Calling functions...
  ;; Would be nice to be able to test for side effects near here
  ;; in nargs+2, out 1
  (definstruction apply-any 23 nargs 1 in (+ nargs 2) out 1 side t argtypes (1))

  (definstruction apply-bvf 24 nargs 1 in (+ nargs 2) out 1 side t argtypes (1))
  ;; in nargs+2, out 1
  (definstruction apply-methods 25 nargs 1 in (+ nargs 2) out 1 side t argtypes (1))
  (definstruction push-label 26 nargs 1 in 0 out 0 argtypes (branch))            ;; a label

  ;; coming back
  ;; We assume that the stack is just (ret val) at this point

  (definstruction return 27 nargs 0 in 2 out 1 side t)
  
  ;; Leaving for real 
  (definstruction i-exit 28 nargs 0 in 0 out 0 side t)

  ;; Allocation
  (definstruction i-cons 29 in 2 out 1 cost 2)
		;; args: size -- reads entry from stack		
  (definstruction alloc-closure 30 nargs 1 in 2 out 1 argtypes (1) cost 3) 
  (definstruction alloc-thing 61 in 1 out 1)
	
  ;; tests
  (definstruction nullp 32 in 1 out 1)
  (definstruction eqp 33 in 2 out 1)

  ;; reflection (hacks)
  (definstruction current-context 35 in 0 out 1)
  (definstruction ensure-stack 36 nargs 1 in 0 out 0 argtypes (1))

  ;; Need labels here --- essentially this is partially IR+OUTPUT

  (definstruction i-label 257 nargs 1 in 0 out 0)
  
  ;; so the output is readable...
  (definstruction dead-code 258 nargs 0 in 0 out 0 nullp t)
	
  ;; User defined types
  ;; from structs.h

  (defconstant bc-macro-type #x27b)
  (export bc-macro-type)

  ;; hack
  ((setter instruct-cost-fn) i-slide-stack-info (lambda (i) (+ (i-arg-ref i 1) 2)))
  ;; end module
  )
