;; Eulisp Module
;; Author: pab
;; File: boot.em
;; Date: Sat Apr 11 19:05:09 1992
;;
;; Project:
;; Description: 
;;   Module that contains functions necessary to boot 
;;   the bytecode system successfully

(defmodule boot
  (lists
   arith
   others
   module-operators
   bci 
   streams
   ccc
   (except (memq mapc append mapcar) list-operators)
   (rename ((find-applicable-methods hidden-f-a-m)) newinit)
   boot-utils
   macros0
   )
  ()
(compile-time
  (defconstant find-applicable-methods hidden-f-a-m)
  (export find-applicable-methods)
  ;; globals
  (deflocal *mod-loc-list* nil)

  ;; include making TELOS here?
  
  ;; install this module....
  
  (defun make-installed-module (name context)
    (let ((mod (make-module name 0)))
      (setq *mod-loc-list* (cons (cons mod context) *mod-loc-list*))
      (set-module-statics mod context)
      mod))
  
  (defun all-registered-modules ()
    *mod-loc-list*)

  (defun make-interface (mod if-desc)
    (let ((import-desc (car if-desc))
	  (exports (cdr if-desc)))
      (mapc (lambda (x) 
	      (add-module-import mod 
				 (car x)
				 (car (cdr x))
				 (car (cdr (cdr x)))))
	    (find-imports import-desc))
      (prin "{")
      ;; Note that we forget where the hell it came from
      (mapc (lambda (x) (add-module-export mod x))
	    exports)
      (prin "}")
      mod))

  (defun find-imports (ispec)
    (cond ((eq (car ispec) 'import)
	   (find-module-exports (car (cdr ispec))))
	  ((eq (car ispec) 'union)
	   (fold (lambda (spec so-far)
		   (append (find-imports spec) so-far))
		 (cdr ispec)
		 nil))
	  ((eq (car ispec) 'except)
	   (let ((lst (car (cdr ispec))))
	     (fold (lambda (x l)
		     (if (memq (car x) lst)
			 l
		       (cons x l)))
		   (find-imports (car (cdr (cdr ispec))))
		   nil)))
	  ;; rename
	  ((eq (car ispec) 'rename)
	   (let ((rename-lst (car (cdr ispec))))
	     (fold (lambda (import lst)
		     (let ((xx (assq (car import) rename-lst)))
		       (if xx
			   (cons (cons (car (cdr xx)) (cdr import))
				 lst)
			 (cons import lst))))
		   (find-imports (car (cdr (cdr ispec))))
		   nil)))
	  ;; only
	  ((eq (car ispec) 'only)
	   (fold (lambda (imp l)
		   (if (memq (car imp) 
			     (car (cdr ispec)))
		       (cons imp l)
		     l))
		 (find-imports (car (cdr (cdr ispec))))
		 nil))
	  (t (print "Unknown import type")
	     (print ispec)
	     nil)))

    
  (defun find-module-exports (mod-name)
    (let ((mod (get-module mod-name)))
      (if (null mod)
	  (progn (prin "no module: ")
		 (print mod-name)
		 nil)
	(let ((lst (module-exports mod)))
	  (mapcar (lambda (name)
		    (list name mod name))
		  lst)))))

  (defun install-local-bindings (mod name-list loc-list)
    (if (null name-list)
	nil
      (progn (add-module-binding mod (car name-list) (car loc-list))
	     (install-local-bindings mod (cdr name-list) (cdr loc-list)))))
  
  (defun append (a b)
    (if (null a) b
      (cons (car a) (append (cdr a) b))))


  ;; used by initcode
  (export make-interface make-module)

  ;; used by linker...
  (export all-registered-modules)

  (print "Boot Initialised.")
  ;; end module
)
  )

  (defun $boot ()
    (let ((my-mod (make-module 'a)))
      (make-interface 'b 'c)
      ($boot-aux mod d)
      ))

  (defun $boot-aux (mod names)
    (if (null names)
	mod
      (set
