;; Boot-utils.em

(defmodule boot-utils
  (macros0
   lists 
   (except (mapcar member reverse mapc memq) list-operators)
   ccc
   streams
   arith)

  ()
  
  ;; necessary functions
  
  (defun fold (fn lst val)
    (if (null lst) val
      (fold fn (cdr lst)
	    (fn (car lst) val))))
  
  (defun reverse (x)
    (fold cons x nil))

  (defun mapcar (fn lst)
    (if (null lst) nil
      (cons (fn (car lst))
	    (mapcar fn (cdr lst)))))

  (defun mapc (f l)
    (if (null l) nil
      (progn (f (car l))
	     (mapc f (cdr l)))))

  (defun assq (obj lst)
    (if (null lst) nil
      (if (eq (car (car lst)) obj) 
	  (car lst)
	(assq obj (cdr lst)))))
  
  (defun member (x l f)
    (cond ((null l) nil)
	  ((f x (car l)))
	  (t (member x (cdr l) f))))

  (defun memq (x a)
    (if (null a) a
      (if (eq x (car a))
	  x
	(memq x (cdr a)))))

  (export fold reverse mapcar assq memq mapc)
)  
