/*
	The commands, with then functions that execute them.
*/

#include "manager.h"
#include "commands.fdf"
#include "concon.h"

Commands cmdList[] =
{
    { "exit",            proCmd_exit },
    { "mem",             proCmd_mem },
    { "gc",              proCmd_gc },
	{ "write",           proCmd_write },
	{ "sym",             proCmd_sym },
	{ "setq",            proCmd_setq },
	{ "set",             proCmd_set },
	{ "unbind",          proCmd_unbind },
	{ "quote",           proCmd_quote },
	{ "eval",            proCmd_eval },
	{ "return",          proCmd_return },
	{ "ref",             proCmd_ref },
	{ "read",            proCmd_read },
	{ "head",            proCmd_head },
	{ "tail",            proCmd_tail },
    { "sin",             proCmd_sin },
    { "asin",            proCmd_asin },
    { "cos",             proCmd_cos },
    { "acos",            proCmd_acos },
    { "tan",             proCmd_tan },
    { "atan",            proCmd_atan },
    { "exp",             proCmd_exp },
    { "log",             proCmd_log },
    { "+",               proCmd_add },
    { "-",               proCmd_sub },
    { "*",               proCmd_mul },
    { "/",               proCmd_div },
	{ "^",               proCmd_raise },
    { "mod",             proCmd_mod },
    { "srand",           proCmd_srand },
    { "rand",            proCmd_rand },
    { "list",            proCmd_list },
    { "clock",           proCmd_clock },
    { ">",               proCmd_largerThan },
    { "<",               proCmd_smallerThan },
    { "eq",              proCmd_eq },
    { "integer?",        proCmd_integerp },
    { "real?",           proCmd_realp },
    { "list?",           proCmd_listp },
    { "assoc",           proCmd_assoc },
    { "if",              proCmd_if },
    { "while",           proCmd_while },
    { "load",            proCmd_load },
    { "let",             proCmd_let },
    { "fork",            proCmd_fork },
    { "unfork",          proCmd_unfork },
    { "title",           proCmd_title },
    { "jobs",            proCmd_jobs },
    { "halt",            proCmd_halt },
    { "busy?",           proCmd_busyp },
    { "not",             proCmd_not },
    { "and",             proCmd_and },
    { "or",              proCmd_or },
    { "lambda",          proCmd_lambda },
    { "macro",           proCmd_macro },

    { "tell",            proCmd_tell },
    { "hear",            proCmd_hear },
    { "mapcar",          proCmd_mapcar },
    { "flat",            proCmd_flat },

    { "select",          proCmd_select },
    { "swap",            proCmd_swap },

    { "atomize",         proCmd_atomize },
    { "explode",         proCmd_explode },
    { "implode",         proCmd_implode },
	{ "inside",          proCmd_inside  },
    { "remove",          proCmd_remove },

    { "indent",          proCmd_indent },
    { "undent",          proCmd_undent },
    { "tabulate",        proCmd_tabulate },
    { "nl",              proCmd_nl },
    { "display",         proCmd_display },
    
    { "stack",           proCmd_stack },
    { "bound?",          proCmd_boundp },
    { "set-tail",        proCmd_setTail },
    { "length",          proCmd_length },
    { "reverse",         proCmd_reverse },
    { "copy",            proCmd_copy },
    { "cond",            proCmd_cond },
    { "next-cond",       proCmd_nextCond },
    { "defmethod",       proCmd_defMethod },
    { "procedure",       proCmd_defProcedure },
    { "abs",             proCmd_abs },
    { "remove-method",   proCmd_removeMethod },
    { "move-method",     proCmd_moveMethod },
    { "error",           proCmd_error },
    { "write-literal",   proCmd_writeLiteral },
    { "dotimes",         proCmd_dotimes },
    { "",                nofunc },
};



