#include <LEDA/graph.h>
#include <LEDA/graph_alg.h>
#include <LEDA/prio1.h>

declare2(prio,node,int)


declare(node_array,pq_item)

void dijkstra(graph& G, 
              node s, 
              edge_array(int)&  cost, 
              node_array(int)&  dist,
              node_array(edge)& pred,
              prio(node,int)&   PQ,
              int INFTY = MAXINT) 
{
  /*
     Dijkstra's Algorithms for integer edge costs,
     computes single source shortest paths from node s for 
     a non-negative network (G,cost), computes for all nodes v:
     a) dist[v] = cost of shortest path from s to v
     b) pred[v] = predecessor edge of v in shortest paths tree
  */

  node_array(pq_item) I(G);
  node v;
                                                                               
  forall_nodes(v,G)
    { pred[v] = 0;
      dist[v] = INFTY;
      I[v] = PQ.insert(v,dist[v]);
     }

  dist[s] = 0;
  PQ.decrease_inf(I[s],0);

  while (! PQ.empty())
  { 
    node u = PQ.del_min();

    if (dist[u] == INFTY) break;

    edge e;
    forall_adj_edges(e,u)
    { v = G.target(e);
      if (dist[u] + cost[e] < dist[v])
      { dist[v] = dist[u] + cost[e];
        pred[v] = e;
        PQ.decrease_inf(I[v],dist[v]);
       }                                                                 
     }                                                                    

   } // while                                                                

}


#include <LEDA/ab_tree.h>
#include <LEDA/rb_tree.h>
#include <LEDA/k_heap.h>

declare3(PRIO,node,int,rb_tree)
declare3(PRIO,node,int,ab_tree)
declare2(B_PRIO,node,k_heap)


void main()
{
  prio(node,int)         FH_Q;
  PRIO(node,int,rb_tree) RB_Q;
  B_PRIO(node,k_heap)    KH_Q(1000);

  graph G;
  edge e;
  node v;

  for(;;)
  {

  int n = read_int("# nodes = ");
  int m = read_int("# edges = ");

  if (n==0) break;;

  random_graph(G,n,m);

  edge_array(int)  cost(G);
  node_array(int)  dist(G);
  node_array(edge) pred(G);

  v = G.choose_node();

  forall_edges(e,G) cost[e] = random(0,100);

  for(;;)
  { int i = read_int("1: f_heap  2: bin_heap  3: rb_tree  --> ");

    if (i==0) break;

    float T  = used_time();

    switch(i)
    {
      case  1: dijkstra(G,v,cost,dist,pred,FH_Q);
               break;
    
      case  2: dijkstra(G,v,cost,dist,pred,KH_Q,1000);
               break;

      case  3: dijkstra(G,v,cost,dist,pred,RB_Q);
               break;
    
      default: break;
     }

    cout << string("time: %6.2f sec\n",used_time(T));
    newline;

   }

 }

}
