//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/Queue.h>				// COOL Queue class
#include <cool/Random.h>			// COOL Random number class

DECLARE Queue<double>;				// Declare a queue of doubles
IMPLEMENT Queue<double>;			// Implement a queue of doubles

int main (void) {
  Queue<double> q1;				// Queue of default size
  Random r (SIMPLE, 1, 3.0, 9.0);		// Simple random generator
  for (int i = 0; i < 5; i++)			// Put five random numbers
    q1.put (r.next ());				// into the queue
    cout << q1 << "\n";				// Output queue elements
  for (q1.reset(); q1.next(); )			// For each element in queue
    if (q1.value() < 4.5)			// If less than tolerance
      q1.remove ();				// Remove from queue
  cout << q1 << "\n";				// Output queue elements
  return (0);
}
  
