//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 08/31/89 -- Initial design and implementation
// Updated: LGO 09/19/89 -- Split into seperate files
// Updated: MJF 03/12/90 -- Added group names to RAISE
//

#include <cool/Base_Vector.h>			// Include the class header
#include <cool/Generic.h>			// Include the class header


// fill_start_error -- Raise exception for Vector<Type>::fill()
// Input:              Type string, start argument
// Output:             None

void Vector::fill_start_error (const char* Type, const long start) CONST {
  RAISE (Error, SYM(Vector), SYM(Out_Of_Range),
	 "Vector<%s>::fill(): Start index %d out of range", Type, start);
}


// fill_end_error -- Raise exception for Vector<Type>::fill()
// Input:            Type string, end argument
// Output:           None

void Vector::fill_end_error (const char* Type, const long end) CONST {
  RAISE (Error, SYM(Vector), SYM(Out_Of_Range),
	 "Vector<%s>::fill(): End index %d out of range", Type, end);
}
