//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: LGO 09/20/89 -- Split into separate file.
// Updated: MJF 02/22/90 -- Changed handler func to a default handler method.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

#if defined(DOS)
extern "C" {
#include <stdlib.h>				// For exit()
//#include <signal.h>				// For signal()
}
#else
#include <stdlib.h>				// For exit()
//#include <signal.h>				// For signal()
#endif

// ******************************************************
// Member function for System_Signal class
// ******************************************************

//  System_Signal::default_handler() - the default handler for System Signal
//                                     simply reports the signal message and
//                                     terminates with exit.
//  
//  INPUT:   None.
//  OUTPUT:  None.

void System_Signal::default_handler() {
  this->report(cerr);		// report signal message
  exit(1);			// and exit
}       

// eh_signal  --  This function will raise a System_Signal exception
//                A pointer to this function is passed to the system
//                function, signal, for a particual type of single.
// INPUT:   Integer representing signal number.
// OUTPUT:  None

void eh_signal(int signum) {
  // system signal function which signals our exception handling mechanism
  (EXCEPTION(System_Signal, signo=signum))->raise();
}

// Example using signal and System_Signal
//
//   signal(my_signum_to_signal, &eh_signal);
// 
//   When system my_signum_to_signal  is raised,  a "System_Signal" Exception 
//   will be raised and will be handled by the default handler for 
//   System_Signal (unless an exception handler is found on the stack).
