//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 06/15/89 -- Initial design and implementation.
// Updated: MJF 02/22/90 -- Split into separate file.
// Updated: MJF 02/22/90 -- Changed to use exception::match().

// An overview of the structure of the IGNORE_ERRS macro and the Jump_Handler
// class can be found in the Ignore_Errs.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.
#include <cool/Ignore_Errs.h>   // include the Ignore_Errs header file.

// **********************************************************************
// Member function for the Jump_Handler class
// **********************************************************************

// Boolean invoke_handler(Exception*)  -- returns TRUE if Handler function
//                                        is invoked on specified Exception;
//                                        otherwise returns FALSE.
//
// Input:   An exception object pointer
// Output:  TRUE or FALSE

Boolean Jump_Handler::invoke_handler(Exception* excp) {
  if (excp->match(this->excp_types) && this->eh_func != NULL) {
    // Jump_Handler's handler function takes two arguments.
    (*(Jump_Handler_Function)this->eh_func)(excp, this);
    excp->handled(TRUE);
    return TRUE;
  } else return FALSE;
}
