//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: LGO 09/20/89 -- Split into separate file.
// Updated: MJF 02/22/90 -- Changed to use exception::match().

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// **********************************************************************
// Friend function for the Excp_Handler class
// **********************************************************************

// Excp_Handler* find_handler(Exception* = NULL, Excp_Handler* = NULL)
//         -- returns Exception Handler for the specified Exception object
//            starting at the specified Exception Handler.
//            If specified Exception Handler is NULL, start at top_handler.
//            If specified Exception is NULL, returns the next available
//            Exception Handler.
//
// Input:   An Exception object pointer and Exception Handler pointer
// Output:  The next Exception Handler pointer

Excp_Handler* find_handler(Exception* exp, Excp_Handler* ehp) {
  Excp_Handler* start_ehp;
  if (ehp == NULL)
    start_ehp = Excp_Handler::top_handler;
  else
    start_ehp = ehp->next_handler;
  if (exp == NULL) return start_ehp;
  for (; start_ehp != NULL && !exp->match(start_ehp->excp_types);
       start_ehp = start_ehp->next_handler);
  return start_ehp;
}
