//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: MJF 02/23/90 -- New function for geting vararg list of exceptions.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#ifndef STDARGH			// If variable args not defined
# if defined(M_XENIX)
#  include <stdarg.hxx>
# else
#  include <stdarg.h>
# endif
#define STDARGH
#endif

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// **********************************************************************
// Function used by Exception, Excp_Handler and Jump_Handler constructors
// **********************************************************************

// get_excps(int, va_list)
//             -- get the variable args of exception types.
//                Used by the Exception::set_group_names() and the 
//                variable arg constructor for Exception, Excp_Handler and
//                Jump_Handler.
//                Returns an array of the exception types.
// Input:   An integer specifying the number of Exception types and a
//          pointer to the first exception type.
// Output:  An array of exception types.

Excp_Type* get_excps(int n, va_list excp_args) {
  Excp_Type* excp_types = (Excp_Type*) new Excp_Type[n+1];
  for (int i = 0; i < n; i++) {
    excp_types[i] = va_arg(excp_args, Excp_Type);
  }
  excp_types[n] = NULL;  // null terminated array
  return excp_types;
}

