
SpherePatch::usage = "SpherePatch[g, z] maps the plane figure g up to the 
sphere and then rotates it along a longitude to the image of the complex 
number z under stereographic projection."

( SpherePatch[g_, z_] := Module[
	{u, v, w}, 
	{u, v, w} = N @ FromSphere @ StereoUp @ TripleFromComplex @ z; 
	StereoUp @ 
		Moebius[
			  Sin[N[Pi] v / 2], 
			  Cos[N[Pi] v / 2] Exp[  I 2 N[Pi] u], 
			- Cos[N[Pi] v / 2] Exp[- I 2 N[Pi] u], 
			  Sin[N[Pi] v / 2] 
		] @ g 
] )

