 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *   Copyright, 1991, The Regents of the University of California.
 *   This software was produced under a U.S. Government contract
 *   (W-7405-ENG-36) by the Los Alamos National Laboratory, which is
 *   operated by the University of California for the U.S. Department
 *   of Energy.  The U.S. Government is licensed to use, reproduce,
 *   and distribute this software.  Neither the Government nor the
 *   University makes any warranty, express or implied, or assumes
 *   any liability responsibility for the use of this software.
 */

#include <math.h>

/*
 *  mean_stddev ()     Given a set of values, and the number of times they
 *                     occur in a given data set, this routine calculates
 *                     the mean and standard deviation for the data.
 *
 *  Written By:  Patrick M. Kelly
 *  Date:        9/23/91  at too darn early in the morning
 */

void mean_stddev ( num_entries, list, count, mean, stddev )

int num_entries;		/* Number of entries in the list */
float *list;			/* List of values */
int  *count;			/* Counts associated with values */
float *mean;			/* (OUTPUT) The mean value */
float *stddev;			/* (OUTPUT) The standard deviation */

{
	int i;			/* Loop control */
	float sum_x;	 	/* Sum of the x terms */
	float sum_x2;		/* Sum of the x squared terms */
	float total_num;	/* Total number */
	float temp;		/* Temporary */

	/*  
	 *  Loop through all values in the table.
	 */

	sum_x = 0.0;
	sum_x2 = 0.0;
	total_num = 0.0;

	for ( i = 0 ; i < num_entries ; i ++ ) {
		total_num += count [i];
		temp = list [i] * count [i];
		sum_x += temp;
		sum_x2 += list [i] * temp;
	}

	/*
	 *  Calculate mean and standard deviation.
	 */
	
	*mean = sum_x / total_num;

	*stddev = sum_x2 - 2.0 * (*mean) * sum_x + 
		  (*mean) * (*mean) * total_num;
	*stddev /= ( total_num - 1.0 );
	*stddev = sqrt ( *stddev );

	return;
}


