 /*
  * Khoros: $Id: xvviewer.c,v 1.2 1992/03/20 22:44:55 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: xvviewer.c,v 1.2 1992/03/20 22:44:55 dkhoros Exp $";
#endif

 /*
  * $Log: xvviewer.c,v $
 * Revision 1.2  1992/03/20  22:44:55  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: xvviewer.c
 >>>>
 >>>>      Program Name: xvviewer
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	This program creates an X window widget  which  displays  an
 >>>>	ascii file.
 >>>>	
 >>>>	

 >>>>            Author: Tom Sauer, Stephanie HAllett
 >>>>
 >>>> Date Last Updated: Wed Mar  4 08:53:41 1992
 >>>>
 >>>>          Routines: main- the main program for xvviewer
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvviewer.h"


/****************************************************************
 *
 * Routine Name:  main program for xvviewer
 *
 *       Input:  
 *          -i  File to View 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        int     fd, i, n;
        char   *title, *filename, *vbasename();
        char    buff[LENGTH];
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        consolidate_args ();
        fd = kopen(xvviewer->i,O_RDONLY,0664);
        if (fd < 0)
        {
           fprintf(stderr,"xvviewer: Cannot read file %s\n",xvviewer->i);
           exit(1);
        }

        /* 
         * Read 100 bytes and see if they are all ascii. If not then assume the
         * file is binary and quit. Otherwise, let the text widget look at it! 
         */
        n = kread(fd,buff,100);
        kclose(fd);
        if (n < 0)
        {
            fprintf(stderr,"xvviewer: Cannot read file %s\n",xvviewer->i);
            exit(1);
        }
        if (n == 0)
        {
            fprintf(stderr,"xvviewer: file %s is empty\n",xvviewer->i);
            exit(1);
        }
        for (i=0; i<n; i++)
        if (!isascii(buff[i]))
        {
             (void) fprintf (stderr,
                "%s: File: %s is not an ascii text file...\n\n",
                program, xvviewer->i);
              exit(1);
        }

        display = xvf_initialize (ac, av, "xvviewer");

        title = VStrcpy("File: ");
        filename = vbasename(xvviewer->i);
        title = VStrcat(title, filename);

        xvf_view_wait(xvviewer->i,title,filename);
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for xvviewer 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "xvviewer :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThis program creates an X window widget  which  displays  an\n");
	fprintf(stderr, "\tascii file.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  File to View  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for xvviewer\n");
	fprintf(stderr, "\t[-V] Gives the version for xvviewer\n");
	fprintf(stderr, "\t[-U] Gives the usage for xvviewer\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called xvviewer.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses xvviewer.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for xvviewer
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) File to View \n        {infile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "xvviewer", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "xvviewer.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "xvviewer: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "xvviewer.ans");
		}

	     }

	}

	/*
	 * allocate the xvviewer structure
	 */
	xvviewer = (xvviewer_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (xvviewer_struct));

	/*
	 * get required arguments for xvviewer
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(xvviewer->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(xvviewer->i))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(xvviewer->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    xvviewer->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(xvviewer->i))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



