 /*
  * Khoros: $Id: axes2.c,v 1.4 1992/03/20 22:40:46 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: axes2.c,v 1.4 1992/03/20 22:40:46 dkhoros Exp $";
#endif

 /*
  * $Log: axes2.c,v $
 * Revision 1.4  1992/03/20  22:40:46  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xprism2.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  axes2.c
   >>>>               
   >>>>   description: This file contains the code for generating
   >>>>			the 2D axes and labels.
   >>>>                
   >>>>      routines: 	
   >>>>			reset_axes()
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  MODULE NAME: reset_axes 
*
*
*      PURPOSE: reset the axes
*
*	INPUT:  None
*
*       OUTPUT: 
*
*   WRITTEN BY: Tom Sauer
*
*
*************************************************************/

reset_axes()
{

	char   temp[512];
	char   *prompt = "Choose a plot to reset axes to";
	char   *label = "Reset Axes";
	int    i, plot_id, num_plots, dummy, plotindex[20]; 
	XawListReturnStruct *list_return;
	XPlot *plot;
	char  *display_list[21];

	/* error check if no workspace or plots */
	if (gwin == NULL) 
	{
    	   xvf_error_wait("No plots displayed in workspace to reset axes to", 
			  "get_plot", NULL);
	   return;
	}

	

	if (gwin->disp_plotnum == 0)
        {
            xvf_error_wait("No plots displayed in workspace to reset axes to",
			   "change_plot_type", NULL);
            return;
        }

        else 
        {
	     find_wc_min_max();
             plot = gwin->plist;
	     num_plots = 0;
	     sprintf(temp, "Global Reset (X: %g, %g) (Y: %g, %g)",
			gwin->WCmin.x, gwin->WCmax.x, 
		        gwin->WCmin.y, gwin->WCmax.y);
	     display_list[num_plots++] = xvf_strcpy(temp);

	     for (i = 0; i < gwin->plotnum; i++) 
             {
		  if (plot->active == true)
		  {
                    if (VStrlen(plot->legend_str) != 0)
                       sprintf(temp, "%s     (X: %g, %g) (Y: %g, %g)",
				plot->legend_str, plot->WCmin.x, 
				plot->WCmax.x, plot->WCmin.y, plot->WCmax.y);
                    else
                       sprintf(temp, "%s     (X: %g, %g) (Y: %g, %g)", 
			       plotnames[plot->id-1], plot->WCmin.x,
			       plot->WCmax.x, plot->WCmin.y, plot->WCmax.y);

                     display_list[num_plots] = xvf_strcpy(temp);
		     plotindex[num_plots++] = plot->id;
		  }
	          plot = plot->next;
	     }

	     list_return = NULL;
	     if(num_plots == 2)
	     {
	         reset_world_coordinates();
	         for (i = 0; i < num_plots; i++)
		      free(display_list[i]);
		 free(temp);
		 return;
	     }
	     if (num_plots > 2)
             {
                list_return = xvf_run_list_wait(display_list, num_plots, 1,
                                             prompt, label, &dummy, FALSE);
	     }
	     if (list_return == NULL)
	     {
	         for (i = 0; i < num_plots; i++)
		      free(display_list[i]);
		 free(temp);
		 return;
	     }

             if (list_return->list_index == 0) 
	     {
	         reset_world_coordinates();
	         for (i = 0; i < num_plots; i++)
		      free(display_list[i]);
		 free(temp);
		 return;
	      }
		
	}

        plot = gwin->plist;
        plot_id = plotindex[list_return->list_index];

	while ((plot->id != plot_id) && (plot->next != NULL))
            plot = plot->next;

        if (plot->id != plot_id)
        {
               (void) sprintf(temp, "Cannot find plot %d\n", plot_id);
                xvf_error_wait(temp, "get_plot", NULL);
		free(temp);
                return;
        }
	    
	set_world_coordinates(plot->WCmin, plot->WCmax, gwin->num_tics);
	for (i = 0; i < num_plots; i++) 
	     free(display_list[i]);
	free(temp);
}
