 /*
  * Khoros: $Id: file.c,v 1.2 1991/10/02 00:20:09 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: file.c,v 1.2 1991/10/02 00:20:09 khoros Exp $";
#endif

 /*
  * $Log: file.c,v $
 * Revision 1.2  1991/10/02  00:20:09  khoros
 * HellPatch2
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 *            Copyright 1990 University of New Mexico
 *
 *  Permission to use, copy, modify, distribute, and sell this
 *  software and its documentation for any purpose is hereby
 *  granted without fee, provided that the above copyright
 *  notice appear in all copies and that both that copyright
 *  notice and this permission notice appear in supporting docu-
 *  mentation, and that the name of UNM not be used in advertis-
 *  ing or publicity pertaining to distribution of the software
 *  without specific, written prior permission.  UNM makes no
 *  representations about the suitability of this software for
 *  any purpose.  It is provided "as is" without express or
 *  implied warranty.
 *
 *  UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 *  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 *  NESS, IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 *  OF THIS SOFTWARE.
 *
 *----------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "warpimage.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>			FIle Routines  	                      <<<<
   >>>>                                                       <<<<
   >>>>			input_src_image()		              <<<<
   >>>>			input_target_image()		              <<<<
   >>>>			input_tp_image()		              <<<<
   >>>>			output_tiepoints()		      <<<<
   >>>>			output_coeffs()			      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


/********************************************************
*
*  Routine Name:  input_src_image
*
*       Purpose: Input a new source image. 
*
*         Input: file - pointer to the file to read image from 
*		 zoom_factor - the zoom factor to set the zoom box to
*
*        Output: None
*
*     Written By: Tom Sauer
*
*
********************************************************/

input_src_image(file, zoom_factor)

char *file;
float zoom_factor;
{
	struct xvimage *new_image, *readimage();
	DisplayStructure *xvdisplay;
	ZoomStructure *zoom;
	char temp[MaxLength];
	char *filename;


	filename = vfullpath(file, NULL, NULL);
	    /*
	     *  read in new image file for the source
	     */
            if ((new_image = readimage(filename)) == NULL) 
	    {
                sprintf(temp, 
		  "readimage failed! Unable to read source image from file %s.",
		         filename);
	        xvf_error_wait(temp, "run_Input", NULL);
	        free(filename);
		return;
	    }
	    if (input_source_image != NULL)
		free(input_source_image);
	    input_source_image = VStrcpy(filename);

	    free(filename);

	    copyheader(new_image, &source_image_header);

            if (new_image->data_storage_type == VFF_TYP_BIT)
            {
              if (! lvconvert(new_image, VFF_TYP_1_BYTE, 1 , 0, 255.0, 1.0, 1))
              {
                 sprintf(temp, 
                     "Unable to convert the BIT source image to a BYTE image");
	         xvf_error_wait(temp, "run_Input", NULL);
		 return;
              }
	    }
       
	    if (tiepoints != NULL)
	    {
	        bzero(temp, MaxLength);
		(void) sprintf(temp,
                  "All tiepoints will be deleted when a new image is read in");
	        if(! xvf_warn_wait(temp,"run_Input", "Cont", "Cancel"))
                {
	            freeimage(new_image);
	            return;
	        }
	    }
	    delete_all_tiepoints();
	    xvdisplay = src_image;
	    zoom = src_zoom;
            zoom->zoomfactor = zoom_factor;

	    /*
             *  call the xvdisplay update routine to update the associated
             *  resources in the xvdisplay structure.
             */
            if (!xvd_update_image(xvdisplay, new_image))
               return;
    	
	    if (zoom->ximage != NULL)
	        XDestroyImage(zoom->ximage);
    
	    if (zoom->ximage = xvd_shrink_ximage(display, xvdisplay->ximage,
                            ZoomDisplayWidth, ZoomDisplayHeight, NULL))
            {
                     if (zoom->ximage->depth == 1)
                        zoom->ximage->format = XYBitmap;
            }
            zoom->assoc_image  = xvdisplay->image;
            zoom->assoc_ximage = xvdisplay->ximage;
            zoom->assoc_raster = xvdisplay->raster;
	    zoom->xpos = zoom->ypos = zoom->xoffset = zoom->yoffset = 0;
            if (zoom->assoc_ximage != NULL)
            {
               zoom->min_x = zoom->assoc_ximage->width/2;
               zoom->min_y = zoom->assoc_ximage->height/2;
            }
            zoom->mode = PointClick;
    
	    xvd_set_colormap(xvdisplay->raster, map_display->colormap);
            xvd_set_colormap(zoom->raster, map_display->colormap);
	    refresh_zoom(zoom);
}

/********************************************************
*
*  Routine Name:  input_target_image
*
*       Purpose: Input a new target image. 
*
*         Input: file - pointer to the file to read image from 
*		 zoom_factor - the zoom factor to set the zoom box to
*
*        Output: None
*
*     Written By: Tom Sauer
*
********************************************************/

input_target_image(file, zoom_factor)

char *file;
float zoom_factor;
{
	struct xvimage *new_image, *readimage();
	DisplayStructure *xvdisplay;
	ZoomStructure *zoom;
	char temp[MaxLength];
	char *filename;


	    filename = vfullpath(file, NULL, NULL);
	    /*
	     *  read in new image file for the source
	     */
            if ((new_image = readimage(filename)) == NULL) 
	    {
	        bzero(temp, MaxLength);
                sprintf(temp, 
	     "readimage failed! Unable to read destination image from file %s.",
		         filename);
	        xvf_error_wait(temp, "run_Input", NULL);
		free(filename);
		return;
	    }

            if (new_image->data_storage_type == VFF_TYP_BIT)
            {
              if (! lvconvert(new_image, VFF_TYP_1_BYTE, 1 , 0, 255.0, 1.0, 1))
              {
	         bzero(temp, MaxLength);
                 sprintf(temp, 
                 "Unable to convert the BIT destination image to a BYTE image");
	         xvf_error_wait(temp, "run_Input", NULL);
		 free(filename);
		 return;
              }
	    }

	    free(filename);
       
	    if (tiepoints != NULL)
	    {
	        bzero(temp, MaxLength);
		(void) sprintf(temp,
                  "All tiepoints will be deleted when a new image is read in");
	        if(! xvf_warn_wait(temp,"run_Input", "Cont", "Cancel"))
                {
	            freeimage(new_image);
	            return;
	        }
	    }
	    delete_all_tiepoints();
	    xvdisplay = dest_image;
	    zoom = dest_zoom;
            zoom->zoomfactor = zoom_factor;

	    /*
             *  call the xvdisplay update routine to update the associated
             *  resources in the xvdisplay structure.
             */
            if (!xvd_update_image(xvdisplay, new_image))
               return;
    	
	    if (zoom->ximage != NULL)
	        XDestroyImage(zoom->ximage);
    
	    if (zoom->ximage = xvd_shrink_ximage(display, xvdisplay->ximage,
                            ZoomDisplayWidth, ZoomDisplayHeight, NULL))
            {
                     if (zoom->ximage->depth == 1)
                        zoom->ximage->format = XYBitmap;
            }
            zoom->assoc_image  = xvdisplay->image;
            zoom->assoc_ximage = xvdisplay->ximage;
            zoom->assoc_raster = xvdisplay->raster;
	    zoom->xpos = zoom->ypos = zoom->xoffset = zoom->yoffset = 0;
            if (zoom->assoc_ximage != NULL)
            {
               zoom->min_x = zoom->assoc_ximage->width/2;
               zoom->min_y = zoom->assoc_ximage->height/2;
            }
            zoom->mode = PointClick;
    
	    xvd_set_colormap(xvdisplay->raster, map_display->colormap);
            xvd_set_colormap(zoom->raster, map_display->colormap);
	    refresh_zoom(zoom);
}

/********************************************************
*
*  Routine Name:  input_tp_image
*
*       Purpose: Input a new source tiepoint image. 
*
*         Input: file - pointer to the file to read image from 
*
*        Output: updates image wiht new tiepoints
*
*     Written By: Tom Sauer
*
*
********************************************************/

input_tp_image(file)

char *file;
{
	struct xvimage *srcimage, *tgt_image, *readimage();
	char temp[MaxLength];
	char *filename, *filename_src, *filename_tgt;
	int **src_value, **tgt_value, *iptr, row;
	int numpoints;
	float *fptr;


	    filename = vfullpath(file, NULL, NULL);
	    filename_src = VStrcat(filename, ".src");
	    filename_tgt = VStrcat(filename, ".tgt");
	    free(filename);

	    /*
	     *  read in new image file for the source
	     */
            if ((srcimage = readimage(filename_src)) == NULL) 
	    {
                sprintf(temp, 
		  "readimage failed! Unable to read the source tiepoint image from file '%s'.",
		         vbasename(filename_src));
	        xvf_error_wait(temp, "input_tp_image", NULL);
	        free(filename_src);
	        free(filename_tgt);
		return;
	    }

	    if (tiepoint_mode == SourceAndDest)
	    {
	       /*
	        *  read in new image file for the source
	        */
               if ((tgt_image = readimage(filename_tgt)) == NULL) 
	       {
                   sprintf(temp, 
		     "readimage failed! Unable to read the target tiepoint image from file '%s'.",
		            vbasename(filename_tgt));
	           xvf_error_wait(temp, "input_tp_image", NULL);
		   freeimage(srcimage);
	           free(filename_src);
	           free(filename_tgt);
		   return;
	       }
	    }
	    free(filename_src);
	    free(filename_tgt);

            if (srcimage->data_storage_type != VFF_TYP_4_BYTE &&
		srcimage->data_storage_type != VFF_TYP_FLOAT)
            {
                 sprintf(temp, 
                     "Source tiepoint image must have a data storage type of either a FLOAT or INTEGER");
	         xvf_error_wait(temp, "input_tp_image", NULL);
		 freeimage(srcimage);
	         if (tiepoint_mode == SourceAndDest)
	           freeimage(tgt_image);
		 return;
            }

            if (srcimage->row_size != 2)
            {
                 sprintf(temp, 
                     "Source tiepoint image must contain only 2 columns of data. This image contain %d Columns", srcimage->row_size);
	         xvf_error_wait(temp, "input_tp_image", NULL);
		 freeimage(srcimage);
	         if (tiepoint_mode == SourceAndDest)
	           freeimage(tgt_image);
		 return;
            }

	    src_value = (int **) calloc(2,sizeof(int *));
	    src_value[0] = (int *) calloc(srcimage->col_size, sizeof(int));
	    src_value[1] = (int *) calloc(srcimage->col_size, sizeof(int));
	    
	    /* 
	     * run through the image to make sure the tiepoints are all valid
	     */

	    if (srcimage->data_storage_type == VFF_TYP_FLOAT)
	       fptr = (float *) srcimage->imagedata;
	    else
	       iptr = (int *) srcimage->imagedata;
	    
	    for (row = 0; row < srcimage->col_size; row++)
	    {
		if (srcimage->data_storage_type == VFF_TYP_FLOAT)
		{
		   src_value[0][row] = (int) *fptr;
		   fptr++;
		   src_value[1][row] = (int) *fptr;
		   fptr++;
		}
		else
		{
		   src_value[0][row] = *iptr;
		   iptr++;
		   src_value[1][row] = *iptr;
		   iptr++;
		}

		if (src_value[0][row] > src_image->image->row_size || src_value[0][row] < 0)
		{
                   sprintf(temp, 
                        "An invalid source X tiepoint position encountered. Tiepoint X location is %d, valid range is 0 - %d",
			  src_value[0][row], src_image->image->row_size);
	           xvf_error_wait(temp, "input_tp_image", NULL);
		   freeimage(srcimage);
	           if (tiepoint_mode == SourceAndDest)
	              freeimage(tgt_image);
		   return;
                }

		if (src_value[1][row] > src_image->image->col_size)
		{
                   sprintf(temp, 
                        "An invalid source Y tiepoint position encountered. Tiepoint Y location is %d, valid range is 0 - %d",
		        src_value[1][row], src_image->image->col_size);
	           xvf_error_wait(temp, "input_tp_image", NULL);
		   freeimage(srcimage);
	           if (tiepoint_mode == SourceAndDest)
	              freeimage(tgt_image);
		   return;
                }
	    }

		/* 
		 * if we have a destination image then add the 
		 * destination tiepoints
		 */
	    
	    if (tiepoint_mode == SourceAndDest)
	    {
               if (tgt_image->data_storage_type != VFF_TYP_4_BYTE &&
		   tgt_image->data_storage_type != VFF_TYP_FLOAT)
               {
                    sprintf(temp, 
                        "Tiepoint image must have a data storage type of either a FLOAT or INTEGER");
	            xvf_error_wait(temp, "input_tp_image", NULL);
		    freeimage(srcimage);
	            freeimage(tgt_image);
		    return;
               }

               if (tgt_image->row_size != 2)
               {
                    sprintf(temp, 
                        "Tiepoint image must contain only 2 columns of data. This image contain %d Columns", tgt_image->row_size);
	            xvf_error_wait(temp, "input_tp_image", NULL);
		    freeimage(srcimage);
	            freeimage(tgt_image);
		    return;
               }

	       if (tgt_image->col_size != srcimage->col_size)
	       {
                    sprintf(temp, 
                        "The source and target tiepioint files must contain the same number of tiepoints. The source file contains %d tiepoints, the target file contains %d tiepoints",
			srcimage->col_size, tgt_image->col_size);
	            xvf_error_wait(temp, "input_tp_image", NULL);
		    freeimage(srcimage);
	            freeimage(tgt_image);
		    return;
	       }

	       tgt_value = (int **) calloc(2,sizeof(int *));
	       tgt_value[0] = (int *) calloc(tgt_image->col_size, sizeof(int));
	       tgt_value[1] = (int *) calloc(tgt_image->col_size, sizeof(int));
	    
	       /* 
	        * run through the image to make sure the tiepoints are all valid
	        */
   
	       if (tgt_image->data_storage_type == VFF_TYP_FLOAT)
	          fptr = (float *) tgt_image->imagedata;
	       else
	          iptr = (int *) tgt_image->imagedata;
	    
	       for (row = 0; row < tgt_image->col_size; row++)
	       {
		   if (tgt_image->data_storage_type == VFF_TYP_FLOAT)
		   {
		      tgt_value[0][row] = (int) *fptr;
		      fptr++;
		      tgt_value[1][row] = (int) *fptr;
		      fptr++;
		   }
		   else
		   {
		      tgt_value[0][row] = *iptr;
		      iptr++;
		      tgt_value[1][row] = *iptr;
		      iptr++;
		   }

		   if (tgt_value[0][row] > dest_image->image->row_size || 
			tgt_value[0][row] < 0)
		   {
                      sprintf(temp, 
                           "An invalid target X tiepoint position encountered for the target image. Tiepoint X location is %d, valid range is 0 - %d",
			     tgt_value[0][row], dest_image->image->row_size);
	              xvf_error_wait(temp, "input_tp_image", NULL);
		      freeimage(srcimage);
	              freeimage(tgt_image);
		      return;
                   }

		   if (tgt_value[1][row] > dest_image->image->col_size)
		   {
                      sprintf(temp, 
                           "An invalid target Y tiepoint position encountered for the target image. Tiepoint Y location is %d, valid range is 0 - %d",
		           tgt_value[1][row], dest_image->image->col_size);
	              xvf_error_wait(temp, "input_tp_image", NULL);
		      freeimage(srcimage);
	              freeimage(tgt_image);
		      return;
                   }
	       }
	    }

	    /* 
	     * if we have tiepoints already, then delete them 	
	     */
       
	    if (tiepoints != NULL)
	    {
	        bzero(temp, MaxLength);
		(void) sprintf(temp,
                  "All tiepoints will be deleted when a src source tiepoint image is read in");
	        if(! xvf_warn_wait(temp,"input_tp_image", "Cont", "Cancel"))
		{
		    freeimage(srcimage);
	            if (tiepoint_mode == SourceAndDest)
	              freeimage(tgt_image);
	            return;
		}
	        delete_all_tiepoints();
	    }
	    
	    numpoints = srcimage->col_size;
	    if (tiepoint_mode == SourceAndDest)
 	    {
	       add_tiepoint(src_value, tgt_value, numpoints, SourceAndDest);
	       refresh_workspace(src_image->raster, src_image->ximage,
			         src_zoom);
	       refresh_workspace(dest_image->raster, dest_image->ximage,
			         dest_zoom);
	    }
	    else
	    {
	        add_tiepoint(src_value, NULL, numpoints, SourceOnly);
		refresh_workspace(src_image->raster, src_image->ximage,
				  src_zoom);
	    }


	    freeimage(srcimage);
	    if (tiepoint_mode == SourceAndDest)
	      freeimage(tgt_image);
}


/************************************************************
*
*  MODULE NAME: output_tiepoints()
*
*      PURPOSE: writes the source and target tiepoints out.
*		The source tiepoints are written to a .src file
*		The target tiepoints are written to a .tgt file
*		Both source and target tiepoints are written to an
*		ascii file  .asc.
*
*        INPUT: basename - basename of file to write image to.
*
*       OUTPUT: tiepoints files
*
*   WRITTEN BY:Tom Sauer
*
**************************************************************/

output_tiepoints(basename)

char *basename;

{

	int      num_tiepoints = 0;
	struct   xvimage *image_src = NULL, *image_tgt = NULL, *createimage();
	char 	 temp1[MaxLength], *temp;
	char	 *filename_src, *filename_tgt, *filename_asc;
	char	 *vbasename();
	TiePointNode *tiepts;
	float    *src_ptr, *tgt_ptr;
	FILE	 *write_device;

	filename_src = vfullpath(VStrcat(basename, ".src"), NULL, NULL);

	filename_tgt = vfullpath(VStrcat(basename, ".tgt"), NULL, NULL);

	filename_asc = vfullpath(VStrcat(basename, ".asc"), NULL, NULL);

	
	tiepts = tiepoints;
	while(tiepts != NULL)
	{
	   num_tiepoints++;
	   tiepts = tiepts->next;
	}
	
	bzero(temp1, MaxLength);
	sprintf(temp1, "Source tiepoint image generated by warpimage");

	image_src = createimage(num_tiepoints, 2, VFF_TYP_FLOAT,
			    1, 1, temp1, 0, 0, VFF_MS_NONE, VFF_MAPTYP_NONE, 
			    VFF_LOC_IMPLICIT, 0);
        image_src->color_space_model = VFF_CM_NONE;

	if (tiepoint_mode == SourceAndDest)
	{
	   bzero(temp1, MaxLength);
	   sprintf(temp1, "Target tiepoint image generated by warpimage");

	   image_tgt = createimage(num_tiepoints, 2, VFF_TYP_FLOAT,
			    1, 1, temp1, 0, 0, VFF_MS_NONE, VFF_MAPTYP_NONE, 
			    VFF_LOC_IMPLICIT, 0);

           image_tgt->color_space_model = VFF_CM_NONE;
	}

	tiepts = tiepoints;
	src_ptr = (float *) image_src->imagedata;
	if (tiepoint_mode == SourceAndDest)
	   tgt_ptr = (float *) image_tgt->imagedata;
	while(tiepts != NULL)
        {
	   *src_ptr = tiepts->src_x; 	   src_ptr++;
	   *src_ptr = tiepts->src_y; 	   src_ptr++;
	   if (tiepoint_mode == SourceAndDest)
	   {
              *tgt_ptr = tiepts->dest_x;      tgt_ptr++;
              *tgt_ptr = tiepts->dest_y;      tgt_ptr++;
	   }
	   tiepts = tiepts->next;
	}


        if (!writeimage(filename_src, image_src))
        {
	   bzero(temp1, MaxLength);
           sprintf(temp1, 
			"writeimage failed! Unable to write image to file %s.",
	                 filename_src);
           xvf_error_wait(temp1, "output_tiepoints", NULL);
           freeimage(image_src); 
           freeimage(image_tgt); 
           return;
        }

	if (tiepoint_mode == SourceAndDest)
	{
           if (!writeimage(filename_tgt, image_tgt))
           {
	      bzero(temp1, MaxLength);
              sprintf(temp1, 
			"writeimage failed! Unable to write image to file %s.",
	                 filename_tgt);
              xvf_error_wait(temp1, "output_tiepoints", NULL);
              freeimage(image_tgt); 
              freeimage(image_src); 
              return;
           }
	}
	
	if(! vwrite_ascii(filename_asc, &write_device))
	{
	   bzero(temp1, MaxLength);
           sprintf(temp1, "Can't open ascii file '%s' to write tiepoints to",
	           filename_asc);
           xvf_error_wait(temp1, "output_tiepoints", NULL);
           freeimage(image_src); 
           freeimage(image_tgt); 
	   return;
	}
	else
	{
	  (void) fprintf(write_device,
	          "\n\tTiepoints Generated From Warp Image\n");
	  (void) fprintf(write_device, "\n\n");
	  (void) fprintf(write_device, 
		"\tTiepoint Number\t\tSource Tiepoint\t\tTarget Tiepoint\n");
	  (void) fprintf(write_device, 
		"\t=================================================================\n\n");

	  (void) fprintf(write_device, "\n\n");
	  tiepts = tiepoints;
	  while(tiepts != NULL)
          {
	        if (tiepoint_mode == SourceAndDest)
	        {
		     (void) fprintf(write_device,
			"\t%d\t\t\t(%4d,%4d)\t\t(%4d,%4d)\n",
		     tiepts->id, tiepts->src_x, tiepts->src_y, tiepts->dest_x, 
		     tiepts->dest_y);
	        }
		else /* source only */
		{
		     (void) fprintf(write_device,
			"\t%d\t\t\t(%4d,%4d)\t\t(0,0)\n",
		     tiepts->id, tiepts->src_x, tiepts->src_y);
		}

	        tiepts = tiepts->next;
  	  }
	}

	(void) fclose(write_device);

	
	bzero(temp1, MaxLength);
        sprintf(temp1, "Source tiepoint image output to file %s\n\n", 
		vbasename(filename_src));
	temp = VStrcpy(temp1);

	if (tiepoint_mode == SourceAndDest)
	{
	   bzero(temp1, MaxLength);
           sprintf(temp1, "Target tiepoint image output to file %s\n\n", 
		   vbasename(filename_tgt));
	
	   temp = VStrcat(temp, temp1);
	}

	bzero(temp1, MaxLength);
        sprintf(temp1, "All Tiepoints output to the ASCII file %s", 
		   vbasename(filename_asc));

	temp = VStrcat(temp, temp1);
        xvf_error_wait(temp, "output_tiepoints", NULL);

	/*
	 *  Cleanup
	 */
	freeimage(image_src);
	if (tiepoint_mode == SourceAndDest)
	  freeimage(image_tgt);
}



/************************************************************
*
*  MODULE NAME: output_coeffs()
*
*      PURPOSE: writes the x and y  coefficients generated
*		by vbilinco.
*
*        INPUT: basename - basename of file to write image to.
*
*       OUTPUT: coefficients file
*
*   WRITTEN BY:Tom Sauer
*
**************************************************************/

output_coeffs(basename)

char *basename;

{

	int      num_tiepoints = 0;
	struct   xvimage *image_x, *image_y;
	char 	 temp1[MaxLength], *temp;
	char	 *filename_x, *filename_y;
	char	 *vbasename();
	TiePointNode *tiepts;

	
	tiepts = tiepoints;
	while(tiepts != NULL)
	{
	   num_tiepoints++;
	   tiepts = tiepts->next;
	}

	if (num_tiepoints < 4)
	{
	   bzero(temp1, MaxLength);
           sprintf(temp1, 
		"At least 4 tiepoints must be specified in order to compute the warping polynomial coefficients. Only %d tiepoints have been specified",
                num_tiepoints);
           xvf_error_wait(temp1, "output_coeffs", NULL);
	   return;
	}

	filename_x = vfullpath(VStrcat(basename, ".x"), NULL, NULL);
	filename_y = vfullpath(VStrcat(basename, ".y"), NULL, NULL);

        if ( ! (compute_binom_coeffs(num_tiepoints, &image_x, &image_y)))
        {
           bzero(temp1, MaxLength);
           (void) sprintf(temp1,
              "Unable to compute the polynomial coefficients");
           xvf_error_wait(temp1, "output_coefs", NULL);
           freeimage(image_x);
           freeimage(image_y);
           return;
        }

        if (!writeimage(filename_x, image_x))
        {
	   bzero(temp1, MaxLength);
           sprintf(temp1, 
		"writeimage failed! Unable to write X coefficients to file %s.",
	                 filename_x);
           xvf_error_wait(temp1, "output_coefs", NULL);
           freeimage(image_x); 
           freeimage(image_y); 
           return;
        }

        if (!writeimage(filename_y, image_y))
        {
	   bzero(temp1, MaxLength);
           sprintf(temp1, 
		"writeimage failed! Unable to write Y coefficients to file %s.",
	                 filename_y);
           xvf_error_wait(temp1, "output_coeffs", NULL);
           freeimage(image_y); 
           freeimage(image_x); 
           return;
        }
	
	bzero(temp1, MaxLength);
        sprintf(temp1, "X polynomial coefficients output to file %s\n\n", 
		vbasename(filename_x));
	temp = VStrcpy(temp1);

	bzero(temp1, MaxLength);
        sprintf(temp1, "Y polynomial coefficients output to file %s\n\n",
		   vbasename(filename_y));
	temp = VStrcat(temp, temp1);
	
        xvf_error_wait(temp, "output_coeffs", NULL);

	/*
	 *  Cleanup
	 */
	freeimage(image_x);
	freeimage(image_y);
}
