 /*
  * Khoros: $Id: vtexture.c,v 1.1 1991/05/10 15:47:43 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vtexture.c,v 1.1 1991/05/10 15:47:43 khoros Exp $";
#endif

 /*
  * $Log: vtexture.c,v $
 * Revision 1.1  1991/05/10  15:47:43  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vtexture.c
 >>>>
 >>>>      Program Name: vtexture
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Texture feature extraction using LAW metrics.
 >>>>	
 >>>>	
 >>>>            Author: Charlie Gage
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:27:28 1991
 >>>>
 >>>>          Routines: main- the main program for vtexture
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vtexture.h"


/****************************************************************
 *
 * Routine Name:  main program for vtexture
 *
 *       Input:  
 *          -i  input image filename 
 *          -o  output image filename 
 *
 *
 *          [-L5L5] choose texture kernel
 *          [-L5E5] choose texture kernel
 *          [-L5S5] choose texture kernel
 *          [-L5W5] choose texture kernel
 *          [-L5R5] choose texture kernel
 *          [-E5L5] choose texture kernel
 *          [-E5E5] choose texture kernel
 *          [-E5S5] choose texture kernel
 *          [-E5W5] choose texture kernel
 *          [-E5R5] choose texture kernel
 *          [-S5L5] choose texture kernel
 *          [-S5E5] choose texture kernel
 *          [-S5S5] choose texture kernel
 *          [-S5W5] choose texture kernel
 *          [-S5R5] choose texture kernel
 *          [-W5L5] choose texture kernel
 *          [-W5E5] choose texture kernel
 *          [-W5S5] choose texture kernel
 *          [-W5W5] choose texture kernel
 *          [-W5R5] choose texture kernel
 *          [-R5L5] choose texture kernel
 *          [-R5E5] choose texture kernel
 *          [-R5S5] choose texture kernel
 *          [-R5W5] choose texture kernel
 *          [-R5R5] choose texture kernel
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
 if (check_args()) exit(1);

 image = readimage(vtexture->i);
 if(image == NULL){ 
    (void) fprintf(stderr,"vtexture: ERROR, Image could not be read\\n"); 
    exit(1); 
  }
/* -main_before_lib_call_end */

/* -main_library_call */
 /* Call the lib routine for texture feature extraction */
if(! lvtexture(image, vtexture->L5L5,vtexture->L5E5,vtexture->L5S5,vtexture->L5W5,vtexture->L5R5,vtexture->E5L5,vtexture->E5E5,vtexture->E5S5,vtexture->E5W5,vtexture->E5R5,vtexture->S5L5,vtexture->S5E5,vtexture->S5S5,vtexture->S5W5,vtexture->S5R5,vtexture->W5L5,vtexture->W5E5,vtexture->W5S5,vtexture->W5W5,vtexture->W5R5,vtexture->R5L5,vtexture->R5E5,vtexture->R5S5,vtexture->R5W5,vtexture->R5R5))
 {
  (void) fprintf(stderr,"ERROR, lvtexture failed\\n");
  exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
(void) writeimage(vtexture->o, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vtexture 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vtexture :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tTexture feature extraction using LAW metrics.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-L5L5]  choose texture kernel (boolean) [true]\n");
	fprintf(stderr,"\t[-L5E5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-L5S5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-L5W5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-L5R5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-E5L5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-E5E5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-E5S5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-E5W5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-E5R5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-S5L5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-S5E5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-S5S5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-S5W5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-S5R5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-W5L5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-W5E5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-W5S5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-W5W5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-W5R5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-R5L5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-R5E5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-R5S5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-R5W5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr,"\t[-R5R5]  choose texture kernel (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vtexture\n");
	fprintf(stderr, "\t[-U] Gives the usage for vtexture\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vtexture.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vtexture.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vtexture
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*L5L5_pstr = 
	"\nEnter: (L5L5) choose texture kernel \n        {boolean, (y/n)  [yes] }: "; 
char	*L5E5_pstr = 
	"\nEnter: (L5E5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*L5S5_pstr = 
	"\nEnter: (L5S5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*L5W5_pstr = 
	"\nEnter: (L5W5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*L5R5_pstr = 
	"\nEnter: (L5R5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*E5L5_pstr = 
	"\nEnter: (E5L5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*E5E5_pstr = 
	"\nEnter: (E5E5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*E5S5_pstr = 
	"\nEnter: (E5S5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*E5W5_pstr = 
	"\nEnter: (E5W5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*E5R5_pstr = 
	"\nEnter: (E5R5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*S5L5_pstr = 
	"\nEnter: (S5L5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*S5E5_pstr = 
	"\nEnter: (S5E5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*S5S5_pstr = 
	"\nEnter: (S5S5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*S5W5_pstr = 
	"\nEnter: (S5W5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*S5R5_pstr = 
	"\nEnter: (S5R5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*W5L5_pstr = 
	"\nEnter: (W5L5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*W5E5_pstr = 
	"\nEnter: (W5E5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*W5S5_pstr = 
	"\nEnter: (W5S5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*W5W5_pstr = 
	"\nEnter: (W5W5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*W5R5_pstr = 
	"\nEnter: (W5R5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*R5L5_pstr = 
	"\nEnter: (R5L5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*R5E5_pstr = 
	"\nEnter: (R5E5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*R5S5_pstr = 
	"\nEnter: (R5S5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*R5W5_pstr = 
	"\nEnter: (R5W5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char	*R5R5_pstr = 
	"\nEnter: (R5R5) choose texture kernel \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vtexture", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vtexture.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vtexture: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vtexture.ans");
		}

	     }

	}

	/*
	 * allocate the vtexture structure
	 */
	vtexture = (vtexture_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vtexture_struct));

	/*
	 * get required arguments for vtexture
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vtexture->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vtexture->i))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vtexture->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vtexture->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vtexture->i))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vtexture->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vtexture->o))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vtexture->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vtexture->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vtexture->o))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vtexture
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vtexture->L5L5_flag = vget_logic(fid, prompt_flag,
	"-L5L5", L5L5_pstr, &(vtexture->L5L5), 1);

	vtexture->L5E5_flag = vget_logic(fid, prompt_flag,
	"-L5E5", L5E5_pstr, &(vtexture->L5E5), 0);

	vtexture->L5S5_flag = vget_logic(fid, prompt_flag,
	"-L5S5", L5S5_pstr, &(vtexture->L5S5), 0);

	vtexture->L5W5_flag = vget_logic(fid, prompt_flag,
	"-L5W5", L5W5_pstr, &(vtexture->L5W5), 0);

	vtexture->L5R5_flag = vget_logic(fid, prompt_flag,
	"-L5R5", L5R5_pstr, &(vtexture->L5R5), 0);

	vtexture->E5L5_flag = vget_logic(fid, prompt_flag,
	"-E5L5", E5L5_pstr, &(vtexture->E5L5), 0);

	vtexture->E5E5_flag = vget_logic(fid, prompt_flag,
	"-E5E5", E5E5_pstr, &(vtexture->E5E5), 0);

	vtexture->E5S5_flag = vget_logic(fid, prompt_flag,
	"-E5S5", E5S5_pstr, &(vtexture->E5S5), 0);

	vtexture->E5W5_flag = vget_logic(fid, prompt_flag,
	"-E5W5", E5W5_pstr, &(vtexture->E5W5), 0);

	vtexture->E5R5_flag = vget_logic(fid, prompt_flag,
	"-E5R5", E5R5_pstr, &(vtexture->E5R5), 0);

	vtexture->S5L5_flag = vget_logic(fid, prompt_flag,
	"-S5L5", S5L5_pstr, &(vtexture->S5L5), 0);

	vtexture->S5E5_flag = vget_logic(fid, prompt_flag,
	"-S5E5", S5E5_pstr, &(vtexture->S5E5), 0);

	vtexture->S5S5_flag = vget_logic(fid, prompt_flag,
	"-S5S5", S5S5_pstr, &(vtexture->S5S5), 0);

	vtexture->S5W5_flag = vget_logic(fid, prompt_flag,
	"-S5W5", S5W5_pstr, &(vtexture->S5W5), 0);

	vtexture->S5R5_flag = vget_logic(fid, prompt_flag,
	"-S5R5", S5R5_pstr, &(vtexture->S5R5), 0);

	vtexture->W5L5_flag = vget_logic(fid, prompt_flag,
	"-W5L5", W5L5_pstr, &(vtexture->W5L5), 0);

	vtexture->W5E5_flag = vget_logic(fid, prompt_flag,
	"-W5E5", W5E5_pstr, &(vtexture->W5E5), 0);

	vtexture->W5S5_flag = vget_logic(fid, prompt_flag,
	"-W5S5", W5S5_pstr, &(vtexture->W5S5), 0);

	vtexture->W5W5_flag = vget_logic(fid, prompt_flag,
	"-W5W5", W5W5_pstr, &(vtexture->W5W5), 0);

	vtexture->W5R5_flag = vget_logic(fid, prompt_flag,
	"-W5R5", W5R5_pstr, &(vtexture->W5R5), 0);

	vtexture->R5L5_flag = vget_logic(fid, prompt_flag,
	"-R5L5", R5L5_pstr, &(vtexture->R5L5), 0);

	vtexture->R5E5_flag = vget_logic(fid, prompt_flag,
	"-R5E5", R5E5_pstr, &(vtexture->R5E5), 0);

	vtexture->R5S5_flag = vget_logic(fid, prompt_flag,
	"-R5S5", R5S5_pstr, &(vtexture->R5S5), 0);

	vtexture->R5W5_flag = vget_logic(fid, prompt_flag,
	"-R5W5", R5W5_pstr, &(vtexture->R5W5), 0);

	vtexture->R5R5_flag = vget_logic(fid, prompt_flag,
	"-R5R5", R5R5_pstr, &(vtexture->R5R5), 0);


}



