 /*
  * Khoros: $Id: viff2tiff.c,v 1.1 1991/05/10 15:53:15 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: viff2tiff.c,v 1.1 1991/05/10 15:53:15 khoros Exp $";
#endif

 /*
  * $Log: viff2tiff.c,v $
 * Revision 1.1  1991/05/10  15:53:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: viff2tiff.c
 >>>>
 >>>>      Program Name: viff2tiff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Convert a VIFF image to a TIFF image
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Sun Mar 10 20:49:46 1991
 >>>>
 >>>>          Routines: main- the main program for viff2tiff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "viff2tiff.h"


/****************************************************************
 *
 * Routine Name:  main program for viff2tiff
 *
 *       Input:  
 *           -i  input VIFF image 
 *           -o  resulting TIFF image 
 *
 *
 *           [-v] verbose mode
 *           [-t] compression type
 *		1 (None),
 *		2 (LZW),
 *		3 (CCITTFAX3),
 *		4 (CCITTRLEW),
 *		or 5 (PACKBITS)
 *		   [default = 2] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        TIFF *tif;
        struct xvimage *viff_image;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    viff_image = readimage(viff2tiff->i_file);
    if (viff_image == NULL)
    {
        (void) fprintf(stderr,"viff2rast: Could not read input image.\n");
       exit(1);
    }

    if ((!propertype (program, viff_image, VFF_TYP_BIT, FALSE)) 
        && (!propertype (program, viff_image, VFF_TYP_1_BYTE, FALSE))) 
    {
        fprintf (stderr, 
                "%s: VIFF image stored in an unconvertable data type.\n",
                program);
        fprintf (stderr, "Should be either bit or byte.\n");
        exit(1);
    }

    if ((!proper_map_type (program, viff_image, VFF_MAPTYP_NONE, FALSE)) 
        && (!proper_map_type (program, viff_image, VFF_MAPTYP_1_BYTE, FALSE))) 
    {
        fprintf (stderr, "%s: Map stored in unconvertable format.\n", program);
        fprintf (stderr, 
                "Should be either VFF_MAPTYP_NONE or VFF_MAPTYP_1_BYTE.\n");
        exit(1);
    }

    if ((!proper_num_bands (program, viff_image, 1, FALSE))
            && (!proper_num_bands (program, viff_image, 3, FALSE))) {
        fprintf (stderr, 
                "%s: Image must have either 1 or 3 bands.\n", program);
        exit(1);
    }

    if ((!proper_map_scheme (program, viff_image, VFF_MS_NONE, FALSE)) 
        && (!proper_map_scheme (program, viff_image, VFF_MS_ONEPERBAND, FALSE))
        && (!proper_map_scheme (program, viff_image, VFF_MS_SHARED, FALSE))) 
    {
        fprintf (stderr, "%s: Unconvertable mapping scheme used.\n", program);
        fprintf (stderr, 
        "Should be either VFF_MS_NONE, VFF_MS_ONEPERBAND or VFF_MS_SHARED.\n");
        exit(1);
    }

    if (!proper_num_images (program, viff_image, 1, FALSE)) 
    {
        fprintf (stderr, "%s: Can only convert files containing 1 image.\n",
                program);
        exit(1);
    }

    if ((!proper_color_model (program, viff_image, VFF_CM_NONE, FALSE)) 
       && (!proper_color_model (program, viff_image, VFF_CM_genericRGB, FALSE)) 
       && (!proper_color_model (program, viff_image, VFF_CM_ntscRGB, FALSE)) 
       && (!proper_color_model (program, viff_image, VFF_CM_cieRGB, FALSE))) 
    {
        fprintf (stderr, "%s: WARNING: Image uses non-RGB color space model.\n",
                program);
        fprintf (stderr, "Image will be interpreted as an RGB image.\n");
    }

    if ((!proper_map_type (program, viff_image, VFF_MAPTYP_NONE, FALSE)) 
        && (proper_num_bands (program, viff_image, 3, FALSE))) 
    {
        fprintf (stderr, 
                  "%s: Can not convert an image with 3 bands and a map.\n",
                program);
        exit(1);
    }

    tif = TIFFOpen(viff2tiff->o_file, "w");
    if (tif == NULL)
    {
        (void) fprintf(stderr,
                "viff2tiff: Could not open TIFF output image for writing\n");
        exit(1);
    }


/* -main_before_lib_call_end */

/* -main_library_call */
        if (! lviff2tiff(tif, viff_image, viff2tiff->v_logic, 
                         compression[viff2tiff->t_toggle -1], 
                         viff2tiff->i_file))
        {
           (void) fprintf(stderr,"viff2tiff: lviff2tiff failed\n");
           exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        TIFFClose(tif);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for viff2tiff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "viff2tiff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConvert a VIFF image to a TIFF image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input VIFF image  (infile)\n");
	fprintf(stderr,"\t-o  resulting TIFF image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-v]  verbose mode (boolean) [false]\n");
	fprintf(stderr, "\t[-t]  compression type\n");
	fprintf(stderr, "\t\t1  (None),\n");
	fprintf(stderr, "\t\t2  (LZW),\n");
	fprintf(stderr, "\t\t3  (CCITTFAX3),\n");
	fprintf(stderr, "\t\t4  (CCITTRLEW),\n");
	fprintf(stderr, "\t\tor 5  (PACKBITS)\n");
	fprintf(stderr, "\t\t[default = 2]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for viff2tiff\n");
	fprintf(stderr, "\t[-U] Gives the usage for viff2tiff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called viff2tiff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses viff2tiff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for viff2tiff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input VIFF image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting TIFF image \n        {outfile}: "; 
char	*v_pstr = 
	"\nEnter: (v) verbose mode \n        {boolean, (y/n)  [no] }: "; 
char	*t_pstr = "\nEnter: (t) compression type -- \n      \t\t1 (None)\n\t\t2 (LZW)\n\t\t3 (CCITTFAX3)\n\t\t4 (CCITTRLEW)\n\t\tor 5 (PACKBITS)\n  [2]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "viff2tiff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "viff2tiff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "viff2tiff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "viff2tiff.ans");
		}

	     }

	}

	/*
	 * allocate the viff2tiff structure
	 */
	viff2tiff = (viff2tiff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (viff2tiff_struct));

	/*
	 * get required arguments for viff2tiff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(viff2tiff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(viff2tiff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viff2tiff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    viff2tiff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(viff2tiff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(viff2tiff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(viff2tiff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viff2tiff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    viff2tiff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(viff2tiff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for viff2tiff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	viff2tiff->v_flag = vget_logic(fid, prompt_flag,
	"-v", v_pstr, &(viff2tiff->v_logic), 0);


	/*
	 * get optional toggles for viff2tiff
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		viff2tiff->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(viff2tiff->t_toggle),
		2, 0, 0);

		if ((viff2tiff->t_toggle == 1 ) || 
		    (viff2tiff->t_toggle == 2 ) || 
		    (viff2tiff->t_toggle == 3 ) || 
		    (viff2tiff->t_toggle == 4 ) || 
		    (viff2tiff->t_toggle == 5 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		viff2tiff->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(viff2tiff->t_toggle),
		2, 0, 0);

		if ((viff2tiff->t_toggle != 1 ) && 
		    (viff2tiff->t_toggle != 2 ) && 
		    (viff2tiff->t_toggle != 3 ) && 
		    (viff2tiff->t_toggle != 4 ) && 
		    (viff2tiff->t_toggle != 5 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



