 /*
  * Khoros: $Id: lbig2viff.c,v 1.1 1991/05/10 15:43:29 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lbig2viff.c,v 1.1 1991/05/10 15:43:29 khoros Exp $";
#endif

 /*
  * $Log: lbig2viff.c,v $
 * Revision 1.1  1991/05/10  15:43:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lbig2viff.c
 >>>>
 >>>>      Program Name: big2viff
 >>>>
 >>>> Date Last Updated: Sat Mar  2 14:17:14 1991 
 >>>>
 >>>>          Routines: lbig2viff - the library call for big2viff
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#include "file_formats/big.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lbig2viff - library call for big2viff
*
* Purpose:
*    
*    Converts a BIG file format to the VIFF image file format.
*    
*    
* Input:
*    
*         struct  big *big_image - pointer to big image
*         struct  xvimage **viff_image - pointer to a  pointer  of  an
*         VIFF image file format.
*         int color_model - the color space  model  specified  by  the
*         user.
*    
*    
* Output:
*    
*         struct  xvimage **viff_image - malloced and copied imagedata
*         for VIFF image
*    
*    
*
* Written By: Tom Sauer
*    
*    Ghosted by Pascal Adam   14-JUNE-90
*    
*    
****************************************************************/


/* -library_def */
int lbig2viff(big_image, viff_image, color_model)

struct  big *big_image;
struct  xvimage **viff_image;
int color_model;
/* -library_def_end */

/* -library_code */
{

    struct  xvimage *img, *createimage();
    char *program = "lbig2viff";
    char *big_ptr, *img_ptr;
   
    int nr, nc, bands;
    int i,j,k;
    int records;

    nr = (int) big_image->num_lines;
    nc = (int) big_image->num_pixels_line;
    bands = (int) big_image->num_channels;

    /* get space for new image and fill in the header info */

   img = createimage(   (unsigned long) nr,              /* number of rows */
                        (unsigned long) nc,              /* number of columns */
                        (unsigned long) VFF_TYP_1_BYTE,  /* data_storage_type */
                        (unsigned long) 1,               /* num_of_images */
                        (unsigned long) bands,           /* num_data_bands */
                        big_image->title,               /* comment */
                        (unsigned long) 0,               /* map_row_size */
                        (unsigned long) 0,               /* map_col_size */
                        (unsigned long) VFF_MS_NONE,     /* map_scheme */
                        (unsigned long) VFF_MAPTYP_NONE, /* map_storage_type */
                        (unsigned long) VFF_LOC_IMPLICIT, /* location_type */
                        (unsigned long) 0);               /* dimension */

   *viff_image = img;
   if ( img == NULL )
   {
       (void)fprintf(stderr,"%s: Unable to allocate new image!\n",program);
       return(0);
   }

     /* load the data according to the VIFF format.
      * note, BIG file format uses band-interleaved-by-line and
      * pads to 512 bytes
     */

   records = big_image->records_line;
   big_ptr = big_image->imagedata;
   img_ptr = img->imagedata;

   for ( i = 0; i < nr; i++) {
     for ( j = 0; j < bands; j++) {
       for ( k = 0; k < nc; k++) {
         img_ptr[ (j * nr * nc) + k + (i * nc) ] = *big_ptr;
         big_ptr++;
       }
       big_ptr = big_ptr + (512 * records - nc);
     }
   }

      /* set the color space model as the user specified */

    set_color_space_model(img, color_model); 
    return(1);

}
/* -library_code_end */
